/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.shortestpaths;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.impl.msbfs.AllShortestPathsStream;
import org.neo4j.gds.impl.msbfs.MSBFSASPAlgorithm;
import org.neo4j.gds.impl.msbfs.MSBFSAllShortestPaths;
import org.neo4j.gds.impl.msbfs.WeightedAllShortestPaths;
import org.neo4j.gds.shortestpaths.AllShortestPathsConfig;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.allShortestPaths.stream", description="The All Pairs Shortest Path (APSP) calculates the shortest (weighted) path between all pairs of nodes.", executionMode=ExecutionMode.STREAM)
public class AllShortestPathsProc
extends AlgoBaseProc<MSBFSASPAlgorithm, Stream<AllShortestPathsStream.Result>, AllShortestPathsConfig, AllShortestPathsStream.Result> {
    public static final String DESCRIPTION = "The All Pairs Shortest Path (APSP) calculates the shortest (weighted) path between all pairs of nodes.";

    @Procedure(name="gds.alpha.allShortestPaths.stream", mode=Mode.READ)
    @Description(value="The All Pairs Shortest Path (APSP) calculates the shortest (weighted) path between all pairs of nodes.")
    public Stream<AllShortestPathsStream.Result> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration, false, false);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    protected AllShortestPathsConfig newConfig(String username, CypherMapWrapper config) {
        return AllShortestPathsConfig.of(config);
    }

    public GraphAlgorithmFactory<MSBFSASPAlgorithm, AllShortestPathsConfig> algorithmFactory() {
        return new GraphAlgorithmFactory<MSBFSASPAlgorithm, AllShortestPathsConfig>(){

            public String taskName() {
                return "MSBFSASPAlgorithm";
            }

            public MSBFSASPAlgorithm build(Graph graph, AllShortestPathsConfig configuration, ProgressTracker progressTracker) {
                if (configuration.hasRelationshipWeightProperty()) {
                    return new WeightedAllShortestPaths(graph, Pools.DEFAULT, configuration.concurrency());
                }
                return new MSBFSAllShortestPaths(graph, configuration.concurrency(), Pools.DEFAULT);
            }
        };
    }

    public ComputationResultConsumer<MSBFSASPAlgorithm, Stream<AllShortestPathsStream.Result>, AllShortestPathsConfig, Stream<AllShortestPathsStream.Result>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            if (computationResult.isGraphEmpty()) {
                computationResult.graph().release();
                return Stream.empty();
            }
            return (Stream)computationResult.result();
        };
    }
}

