/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scc;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.LongNodeProperties;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.impl.scc.SccAlgorithm;
import org.neo4j.gds.impl.scc.SccConfig;
import org.neo4j.gds.result.AbstractCommunityResultBuilder;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.scc.SccProc;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.scc.write", description="The SCC algorithm finds sets of connected nodes in an directed graph, where all nodes in the same set form a connected component.", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class SccWriteProc
extends SccProc<SccResult> {
    @Procedure(value="gds.alpha.scc.write", mode=Mode.WRITE)
    @Description(value="The SCC algorithm finds sets of connected nodes in an directed graph, where all nodes in the same set form a connected component.")
    public Stream<SccResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    public ComputationResultConsumer<SccAlgorithm, HugeLongArray, SccConfig, Stream<SccResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            SccAlgorithm algorithm = (SccAlgorithm)computationResult.algorithm();
            final HugeLongArray components = (HugeLongArray)computationResult.result();
            SccConfig config = (SccConfig)computationResult.config();
            Graph graph = computationResult.graph();
            AbstractResultBuilder writeBuilder = new SccResultBuilder(this.callContext, config.concurrency()).buildCommunityCount(true).buildHistogram(true).withCommunityFunction(components != null ? arg_0 -> ((HugeLongArray)components).get(arg_0) : null).withNodeCount(graph.nodeCount()).withConfig((AlgoBaseConfig)config).withPreProcessingMillis(computationResult.preProcessingMillis()).withComputeMillis(computationResult.computeMillis());
            if (graph.isEmpty()) {
                graph.release();
                return Stream.of((SccResult)writeBuilder.build());
            }
            try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> ((AbstractResultBuilder)writeBuilder).withWriteMillis(arg_0));){
                TaskProgressTracker progressTracker = new TaskProgressTracker(NodePropertyExporter.baseTask((String)"Scc", (long)graph.nodeCount()), this.log, config.writeConcurrency(), this.taskRegistryFactory);
                NodePropertyExporter exporter = this.nodePropertyExporterBuilder.withIdMap((IdMap)graph).withTerminationFlag(algorithm.getTerminationFlag()).withProgressTracker((ProgressTracker)progressTracker).parallel(Pools.DEFAULT, config.writeConcurrency()).build();
                LongNodeProperties properties = new LongNodeProperties(){

                    public long size() {
                        return computationResult.graph().nodeCount();
                    }

                    public long longValue(long nodeId) {
                        return components.get(nodeId);
                    }
                };
                exporter.write(config.writeProperty(), (NodeProperties)properties);
                writeBuilder.withNodePropertiesWritten(exporter.propertiesWritten());
            }
            graph.release();
            return Stream.of((SccResult)writeBuilder.build());
        };
    }

    public static final class SccResultBuilder
    extends AbstractCommunityResultBuilder<SccResult> {
        SccResultBuilder(ProcedureCallContext context, int concurrency) {
            super(context, concurrency);
        }

        public SccResult buildResult() {
            return new SccResult(this.preProcessingMillis, this.computeMillis, this.writeMillis, this.postProcessingDuration, this.nodeCount, this.maybeCommunityCount.orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(100.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(99.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(95.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(90.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(75.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(50.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(25.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(10.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(5.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(1.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getMinNonZeroValue()).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getMaxValue()).orElse(0L), this.config instanceof WritePropertyConfig ? ((WritePropertyConfig)this.config).writeProperty() : "");
        }

        public SccResultBuilder buildHistogram(boolean buildHistogram) {
            this.buildHistogram = buildHistogram;
            return this;
        }

        public SccResultBuilder buildCommunityCount(boolean buildCommunityCount) {
            this.buildCommunityCount = buildCommunityCount;
            return this;
        }
    }

    public static class SccResult {
        public final long preProcessingMillis;
        public final long computeMillis;
        public final long writeMillis;
        public final long postProcessingMillis;
        public final long nodes;
        public final long communityCount;
        public final long setCount;
        public final long minSetSize;
        public final long maxSetSize;
        public final long p1;
        public final long p5;
        public final long p10;
        public final long p25;
        public final long p50;
        public final long p75;
        public final long p90;
        public final long p95;
        public final long p99;
        public final long p100;
        public final String writeProperty;

        public SccResult(long preProcessingMillis, long computeMillis, long postProcessingMillis, long writeMillis, long nodes, long communityCount, long p100, long p99, long p95, long p90, long p75, long p50, long p25, long p10, long p5, long p1, long minSetSize, long maxSetSize, String writeProperty) {
            this.preProcessingMillis = preProcessingMillis;
            this.computeMillis = computeMillis;
            this.postProcessingMillis = postProcessingMillis;
            this.writeMillis = writeMillis;
            this.nodes = nodes;
            this.setCount = this.communityCount = communityCount;
            this.p100 = p100;
            this.p99 = p99;
            this.p95 = p95;
            this.p90 = p90;
            this.p75 = p75;
            this.p50 = p50;
            this.p25 = p25;
            this.p10 = p10;
            this.p5 = p5;
            this.p1 = p1;
            this.minSetSize = minSetSize;
            this.maxSetSize = maxSetSize;
            this.writeProperty = writeProperty;
        }
    }
}

