/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.splitting;

import java.util.Collection;
import java.util.Optional;
import org.neo4j.gds.GraphStoreAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.ml.splitting.SplitRelationships;
import org.neo4j.gds.ml.splitting.SplitRelationshipsMutateConfig;

public class SplitRelationshipsAlgorithmFactory
extends GraphStoreAlgorithmFactory<SplitRelationships, SplitRelationshipsMutateConfig> {
    public String taskName() {
        return "SplitRelationships";
    }

    public SplitRelationships build(GraphStore graphStore, SplitRelationshipsMutateConfig configuration, ProgressTracker progressTracker) {
        Graph graph;
        Optional weightProperty = configuration != null ? Optional.ofNullable(configuration.relationshipWeightProperty()) : Optional.empty();
        Collection nodeLabels = configuration.nodeLabelIdentifiers(graphStore);
        Collection relationshipTypes = configuration.internalRelationshipTypes(graphStore);
        Graph masterGraph = graph = graphStore.getGraph(nodeLabels, relationshipTypes, weightProperty);
        if (!configuration.nonNegativeRelationshipTypes().isEmpty()) {
            masterGraph = graphStore.getGraph(configuration.nodeLabelIdentifiers(graphStore), (Collection)configuration.superGraphTypes(), Optional.empty());
        }
        return new SplitRelationships(graph, masterGraph, configuration);
    }

    public MemoryEstimation memoryEstimation(SplitRelationshipsMutateConfig configuration) {
        return SplitRelationships.estimate((SplitRelationshipsMutateConfig)configuration);
    }
}

