/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels.pipeline;

import java.util.List;
import java.util.Map;
import org.neo4j.gds.ml.nodemodels.pipeline.PipelineInfoResult;
import org.neo4j.gds.ml.pipeline.FeatureStep;
import org.neo4j.gds.ml.pipeline.NodePropertyStepFactory;
import org.neo4j.gds.ml.pipeline.PipelineCatalog;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodeClassificationFeatureStep;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodeClassificationPipeline;

public final class NodeClassificationPipelineAddSteps {
    private NodeClassificationPipelineAddSteps() {
    }

    public static PipelineInfoResult addNodeProperty(String username, String pipelineName, String taskName, Map<String, Object> procedureConfig) {
        NodeClassificationPipeline pipeline = (NodeClassificationPipeline)PipelineCatalog.getTyped((String)username, (String)pipelineName, NodeClassificationPipeline.class);
        pipeline.addNodePropertyStep(NodePropertyStepFactory.createNodePropertyStep((String)taskName, procedureConfig));
        return new PipelineInfoResult(pipelineName, pipeline);
    }

    public static PipelineInfoResult selectFeatures(String username, String pipelineName, Object nodeProperties) {
        NodeClassificationPipeline pipeline = (NodeClassificationPipeline)PipelineCatalog.getTyped((String)username, (String)pipelineName, NodeClassificationPipeline.class);
        if (nodeProperties instanceof String) {
            pipeline.addFeatureStep((FeatureStep)NodeClassificationFeatureStep.of((String)((String)nodeProperties)));
        } else if (nodeProperties instanceof List) {
            List propertiesList = (List)nodeProperties;
            for (Object o : propertiesList) {
                if (!(o instanceof String)) {
                    throw new IllegalArgumentException("The list `nodeProperties` is required to contain only strings.");
                }
                pipeline.addFeatureStep((FeatureStep)NodeClassificationFeatureStep.of((String)((String)o)));
            }
        } else {
            throw new IllegalArgumentException("The value of `nodeProperties` is required to be a list of strings.");
        }
        return new PipelineInfoResult(pipelineName, pipeline);
    }
}

