/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.ml.linkmodels.LinkPredictionResult;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionSimilarityComputer;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureExtractor;
import org.neo4j.gds.models.Classifier;

public abstract class LinkPrediction
extends Algorithm<LinkPredictionResult> {
    static final int MIN_NODE_BATCH_SIZE = 10;
    private final Classifier classifier;
    private final LinkFeatureExtractor linkFeatureExtractor;
    private final Graph graph;
    protected final int concurrency;

    LinkPrediction(Classifier classifier, LinkFeatureExtractor linkFeatureExtractor, Graph graph, int concurrency, ProgressTracker progressTracker) {
        super(progressTracker);
        this.classifier = classifier;
        this.linkFeatureExtractor = linkFeatureExtractor;
        this.graph = graph;
        this.concurrency = concurrency;
    }

    public LinkPredictionResult compute() {
        this.progressTracker.beginSubTask();
        LinkPredictionResult result = this.predict();
        this.progressTracker.endSubTask();
        return result;
    }

    private LinkPredictionResult predict() {
        LinkPredictionSimilarityComputer linkPredictionSimilarityComputer = new LinkPredictionSimilarityComputer(this.linkFeatureExtractor, this.classifier);
        return this.predictLinks(this.graph, linkPredictionSimilarityComputer);
    }

    abstract LinkPredictionResult predictLinks(Graph var1, LinkPredictionSimilarityComputer var2);

    public void release() {
    }
}

