/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.linkmodels.pipeline.PipelineInfoResult;
import org.neo4j.gds.ml.pipeline.PipelineCatalog;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkPredictionPipeline;
import org.neo4j.gds.models.TrainerConfig;
import org.neo4j.gds.models.TrainingMethod;
import org.neo4j.gds.models.logisticregression.LogisticRegressionTrainConfig;
import org.neo4j.gds.models.randomforest.RandomForestTrainConfig;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class LinkPredictionPipelineAddTrainerMethodProcs
extends BaseProc {
    @Procedure(name="gds.beta.pipeline.linkPrediction.addLogisticRegression", mode=Mode.READ)
    @Description(value="Add a logistic regression configuration to the parameter space of the link prediction train pipeline.")
    public Stream<PipelineInfoResult> addLogisticRegression(@Name(value="pipelineName") String pipelineName, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        LinkPredictionPipeline pipeline = (LinkPredictionPipeline)PipelineCatalog.getTyped((String)this.username(), (String)pipelineName, LinkPredictionPipeline.class);
        LogisticRegressionTrainConfig lrConfig = LogisticRegressionTrainConfig.of(config);
        this.validateConfig(CypherMapWrapper.create(config), lrConfig.configKeys());
        pipeline.addTrainerConfig(TrainingMethod.LogisticRegression, (TrainerConfig)lrConfig);
        return Stream.of(new PipelineInfoResult(pipelineName, pipeline));
    }

    @Procedure(name="gds.alpha.pipeline.linkPrediction.addRandomForest", mode=Mode.READ)
    @Description(value="Add a random forest configuration to the parameter space of the link prediction train pipeline.")
    public Stream<PipelineInfoResult> addRandomForest(@Name(value="pipelineName") String pipelineName, @Name(value="config") Map<String, Object> randomForestConfig) {
        LinkPredictionPipeline pipeline = (LinkPredictionPipeline)PipelineCatalog.getTyped((String)this.username(), (String)pipelineName, LinkPredictionPipeline.class);
        RandomForestTrainConfig trainConfig = RandomForestTrainConfig.of(randomForestConfig);
        this.validateConfig(CypherMapWrapper.create(randomForestConfig), trainConfig.configKeys());
        pipeline.addTrainerConfig(TrainingMethod.RandomForest, (TrainerConfig)trainConfig);
        return Stream.of(new PipelineInfoResult(pipelineName, pipeline));
    }
}

