/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.centrality;

import java.util.Map;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.centrality.HarmonicCentralityProc;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.impl.closeness.HarmonicCentralityConfig;
import org.neo4j.gds.impl.harmonic.HarmonicCentrality;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.closeness.harmonic.stream", description="Harmonic centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.", executionMode=ExecutionMode.STREAM)
public class HarmonicCentralityStreamProc
extends HarmonicCentralityProc<StreamResult> {
    @Procedure(name="gds.alpha.closeness.harmonic.stream", mode=Mode.READ)
    @Description(value="Harmonic centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.")
    public Stream<StreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    public ComputationResultConsumer<HarmonicCentrality, HarmonicCentrality, HarmonicCentralityConfig, Stream<StreamResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            HarmonicCentrality algorithm = (HarmonicCentrality)computationResult.algorithm();
            Graph graph = computationResult.graph();
            if (graph.isEmpty()) {
                graph.release();
                return Stream.empty();
            }
            return LongStream.range(0L, graph.nodeCount()).boxed().map(nodeId -> new StreamResult(graph.toOriginalNodeId(nodeId.longValue()), algorithm.getCentralityScore(nodeId.longValue())));
        };
    }

    public static final class StreamResult {
        public final long nodeId;
        public final double centrality;

        StreamResult(long nodeId, double centrality) {
            this.nodeId = nodeId;
            this.centrality = centrality;
        }
    }
}

