/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.spanningtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.spanningtree.KSpanningTreeConfig;

public final class KSpanningTreeConfigImpl
implements KSpanningTreeConfig {
    private long k;
    private String writeProperty;
    private long startNodeId;
    private DoubleUnaryOperator minMax;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    @Nullable
    private String usernameOverride;
    private boolean sudo;
    private int concurrency;
    private int writeConcurrency;
    @Nullable
    private String relationshipWeightProperty;

    public KSpanningTreeConfigImpl(@NotNull DoubleUnaryOperator minMax, @NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.k = config.requireLong("k");
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeProperty = (String)CypherMapWrapper.failOnNull((String)"writeProperty", (Object)config.getString("writeProperty", KSpanningTreeConfig.super.writeProperty()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.startNodeId = config.requireLong("startNodeId");
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.minMax = (DoubleUnaryOperator)CypherMapWrapper.failOnNull((String)"minMax", (Object)minMax);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)KSpanningTreeConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)KSpanningTreeConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = StringUtils.trimToNull((String)config.getString("username", KSpanningTreeConfig.super.usernameOverride()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", KSpanningTreeConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", KSpanningTreeConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeConcurrency = config.getInt("writeConcurrency", KSpanningTreeConfig.super.writeConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipWeightProperty = RelationshipWeightConfig.validatePropertyName((String)config.getString("relationshipWeightProperty", KSpanningTreeConfig.super.relationshipWeightProperty()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateWriteConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public long k() {
        return this.k;
    }

    @Override
    public String writeProperty() {
        return this.writeProperty;
    }

    @Override
    public long startNodeId() {
        return this.startNodeId;
    }

    @Override
    public DoubleUnaryOperator minMax() {
        return this.minMax;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        this.relationshipWeightValidation(graphStore, selectedLabels, selectedRelationshipTypes);
    }

    @Nullable
    public String usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("k", "writeProperty", "startNodeId", "relationshipTypes", "nodeLabels", "username", "sudo", "concurrency", "writeConcurrency", "relationshipWeightProperty");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("k", this.k());
        map.put("writeProperty", this.writeProperty());
        map.put("startNodeId", this.startNodeId());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("username", this.usernameOverride());
        map.put("sudo", this.sudo());
        map.put("concurrency", this.concurrency());
        map.put("writeConcurrency", this.writeConcurrency());
        map.put("relationshipWeightProperty", this.relationshipWeightProperty());
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public int writeConcurrency() {
        return this.writeConcurrency;
    }

    @Nullable
    public String relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();
        @NotNull
        private DoubleUnaryOperator minMax;

        public Builder minMax(DoubleUnaryOperator minMax) {
            this.minMax = minMax;
            return this;
        }

        public Builder k(long k) {
            this.config.put("k", k);
            return this;
        }

        public Builder writeProperty(String writeProperty) {
            this.config.put("writeProperty", writeProperty);
            return this;
        }

        public Builder startNodeId(long startNodeId) {
            this.config.put("startNodeId", startNodeId);
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder writeConcurrency(int writeConcurrency) {
            this.config.put("writeConcurrency", writeConcurrency);
            return this;
        }

        public Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.config.put("relationshipWeightProperty", relationshipWeightProperty);
            return this;
        }

        public KSpanningTreeConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new KSpanningTreeConfigImpl(this.minMax, config);
        }
    }
}

