/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels.pipeline.predict;

import java.util.List;
import org.neo4j.gds.GraphStoreAlgorithmFactory;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.ml.nodemodels.pipeline.NodeClassificationPipelineCompanion;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPredictPipelineBaseConfig;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPredictPipelineExecutor;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodeClassificationPipeline;
import org.neo4j.gds.ml.pipeline.nodePipeline.train.NodeClassificationPipelineModelInfo;
import org.neo4j.gds.ml.pipeline.nodePipeline.train.NodeClassificationPipelineTrainConfig;
import org.neo4j.gds.models.Classifier;

public class NodeClassificationPredictPipelineAlgorithmFactory<CONFIG extends NodeClassificationPredictPipelineBaseConfig>
extends GraphStoreAlgorithmFactory<NodeClassificationPredictPipelineExecutor, CONFIG> {
    private final ModelCatalog modelCatalog;
    private final ExecutionContext executionContext;

    NodeClassificationPredictPipelineAlgorithmFactory(ExecutionContext executionContext, ModelCatalog modelCatalog) {
        this.modelCatalog = modelCatalog;
        this.executionContext = executionContext;
    }

    public Task progressTask(GraphStore graphStore, CONFIG config) {
        NodeClassificationPipeline trainingPipeline = ((NodeClassificationPipelineModelInfo)NodeClassificationPipelineCompanion.getTrainedNCPipelineModel(this.modelCatalog, config.modelName(), config.username()).customInfo()).trainingPipeline();
        return Tasks.task((String)this.taskName(), (Task)Tasks.iterativeFixed((String)"execute node property steps", () -> List.of(Tasks.leaf((String)"step")), (int)trainingPipeline.nodePropertySteps().size()), (Task[])new Task[]{Tasks.leaf((String)"Node classification predict", (long)graphStore.getUnion().nodeCount())});
    }

    public String taskName() {
        return "Node Classification Predict Pipeline";
    }

    public NodeClassificationPredictPipelineExecutor build(GraphStore graphStore, CONFIG configuration, ProgressTracker progressTracker) {
        Model<Classifier.ClassifierData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> model = NodeClassificationPipelineCompanion.getTrainedNCPipelineModel(this.modelCatalog, configuration.modelName(), configuration.username());
        NodeClassificationPipeline nodeClassificationPipeline = ((NodeClassificationPipelineModelInfo)model.customInfo()).trainingPipeline();
        return new NodeClassificationPredictPipelineExecutor(nodeClassificationPipeline, (NodeClassificationPredictPipelineBaseConfig)configuration, this.executionContext, graphStore, configuration.graphName(), progressTracker, (Classifier.ClassifierData)model.data());
    }

    public MemoryEstimation memoryEstimation(CONFIG configuration) {
        Model<Classifier.ClassifierData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> model = NodeClassificationPipelineCompanion.getTrainedNCPipelineModel(this.modelCatalog, configuration.modelName(), configuration.username());
        return MemoryEstimations.builder(NodeClassificationPredictPipelineExecutor.class).add("Pipeline executor", NodeClassificationPredictPipelineExecutor.estimate(model, configuration, this.modelCatalog)).build();
    }
}

