/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels.pipeline.predict;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.GraphStoreAlgorithmFactory;
import org.neo4j.gds.MutatePropertyProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.DoubleArrayNodeProperties;
import org.neo4j.gds.api.nodeproperties.LongNodeProperties;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.write.NodeProperty;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.ml.PipelineCompanion;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredict;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPipelineCompanion;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPredictPipelineAlgorithmFactory;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPredictPipelineExecutor;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPredictPipelineMutateConfig;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.results.StandardMutateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.beta.pipeline.nodeClassification.predict.mutate", description="Predicts classes for all nodes based on a previously trained pipeline model", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY)
public class NodeClassificationPipelineMutateProc
extends MutatePropertyProc<NodeClassificationPredictPipelineExecutor, NodeClassificationPredict.NodeClassificationResult, MutateResult, NodeClassificationPredictPipelineMutateConfig> {
    @Procedure(name="gds.beta.pipeline.nodeClassification.predict.mutate", mode=Mode.READ)
    @Description(value="Predicts classes for all nodes based on a previously trained pipeline model")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        PipelineCompanion.prepareTrainConfig(graphName, configuration);
        return this.mutate(this.compute(graphName, configuration));
    }

    @Procedure(name="gds.beta.pipeline.nodeClassification.predict.mutate.estimate", mode=Mode.READ)
    @Description(value="Estimates memory for predicting classes for all nodes based on a previously trained pipeline model")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        PipelineCompanion.prepareTrainConfig(graphNameOrConfiguration, algoConfiguration);
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    public ValidationConfiguration<NodeClassificationPredictPipelineMutateConfig> validationConfig() {
        return NodeClassificationPipelineCompanion.getValidationConfig();
    }

    public AlgorithmSpec<NodeClassificationPredictPipelineExecutor, NodeClassificationPredict.NodeClassificationResult, NodeClassificationPredictPipelineMutateConfig, Stream<MutateResult>, AlgorithmFactory<?, NodeClassificationPredictPipelineExecutor, NodeClassificationPredictPipelineMutateConfig>> withModelCatalog(ModelCatalog modelCatalog) {
        this.setModelCatalog(modelCatalog);
        return this;
    }

    protected List<NodeProperty> nodePropertyList(ComputationResult<NodeClassificationPredictPipelineExecutor, NodeClassificationPredict.NodeClassificationResult, NodeClassificationPredictPipelineMutateConfig> computationResult) {
        NodeClassificationPredictPipelineMutateConfig config = (NodeClassificationPredictPipelineMutateConfig)computationResult.config();
        String mutateProperty = config.mutateProperty();
        NodeClassificationPredict.NodeClassificationResult result = (NodeClassificationPredict.NodeClassificationResult)computationResult.result();
        LongNodeProperties classProperties = result.predictedClasses().asNodeProperties();
        ArrayList<NodeProperty> nodeProperties = new ArrayList<NodeProperty>();
        nodeProperties.add(NodeProperty.of((String)mutateProperty, (NodeProperties)classProperties));
        result.predictedProbabilities().ifPresent(probabilityProperties -> {
            DoubleArrayNodeProperties properties = new DoubleArrayNodeProperties((ComputationResult)computationResult, (HugeObjectArray)probabilityProperties){
                final /* synthetic */ ComputationResult val$computationResult;
                final /* synthetic */ HugeObjectArray val$probabilityProperties;
                {
                    this.val$computationResult = computationResult;
                    this.val$probabilityProperties = hugeObjectArray;
                }

                public long size() {
                    return this.val$computationResult.graph().nodeCount();
                }

                public double[] doubleArrayValue(long nodeId) {
                    return (double[])this.val$probabilityProperties.get(nodeId);
                }
            };
            nodeProperties.add(NodeProperty.of((String)config.predictedProbabilityProperty().orElseThrow(), (NodeProperties)properties));
        });
        return nodeProperties;
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(ComputationResult<NodeClassificationPredictPipelineExecutor, NodeClassificationPredict.NodeClassificationResult, NodeClassificationPredictPipelineMutateConfig> computeResult, ExecutionContext executionContext) {
        return new MutateResult.Builder();
    }

    protected NodeClassificationPredictPipelineMutateConfig newConfig(String username, CypherMapWrapper config) {
        return NodeClassificationPredictPipelineMutateConfig.of(username, config);
    }

    public GraphStoreAlgorithmFactory<NodeClassificationPredictPipelineExecutor, NodeClassificationPredictPipelineMutateConfig> algorithmFactory() {
        return new NodeClassificationPredictPipelineAlgorithmFactory<NodeClassificationPredictPipelineMutateConfig>(this.executionContext(), this.modelCatalog());
    }

    public static final class MutateResult
    extends StandardMutateResult {
        public final long nodePropertiesWritten;

        MutateResult(long preProcessingMillis, long computeMillis, long mutateMillis, long nodePropertiesWritten, Map<String, Object> configuration) {
            super(preProcessingMillis, computeMillis, 0L, mutateMillis, configuration);
            this.nodePropertiesWritten = nodePropertiesWritten;
        }

        static class Builder
        extends AbstractResultBuilder<MutateResult> {
            Builder() {
            }

            public MutateResult build() {
                return new MutateResult(this.preProcessingMillis, this.computeMillis, this.mutateMillis, this.nodePropertiesWritten, this.config.toMap());
            }
        }
    }
}

