/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels.pipeline;

import java.util.List;
import java.util.Map;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.ml.pipeline.nodePipeline.train.NodeClassificationPipelineModelInfo;
import org.neo4j.gds.ml.pipeline.nodePipeline.train.NodeClassificationPipelineTrainConfig;
import org.neo4j.gds.models.Classifier;
import org.neo4j.gds.models.TrainingMethod;

public final class NodeClassificationPipelineCompanion {
    public static final String PREDICT_DESCRIPTION = "Predicts classes for all nodes based on a previously trained pipeline model";
    public static final String ESTIMATE_PREDICT_DESCRIPTION = "Estimates memory for predicting classes for all nodes based on a previously trained pipeline model";
    static final Map<String, Object> DEFAULT_SPLIT_CONFIG = Map.of("testFraction", 0.3, "validationFolds", 3);
    static final Map<String, List<Map<String, Object>>> DEFAULT_PARAM_CONFIG = Map.of(TrainingMethod.LogisticRegression.name(), List.of(), TrainingMethod.RandomForest.name(), List.of());

    private NodeClassificationPipelineCompanion() {
    }

    public static Model<Classifier.ClassifierData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> getTrainedNCPipelineModel(ModelCatalog modelCatalog, String modelName, String username) {
        return modelCatalog.get(username, modelName, Classifier.ClassifierData.class, NodeClassificationPipelineTrainConfig.class, NodeClassificationPipelineModelInfo.class);
    }
}

