/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.beta.pregel.Pregel;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.PregelResult;
import org.neo4j.gds.beta.pregel.PregelSchema;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.pregel.Hits;
import org.neo4j.gds.pregel.HitsAlgorithm;
import org.neo4j.gds.pregel.proc.PregelWriteProc;
import org.neo4j.gds.pregel.proc.PregelWriteResult;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.hits.write", executionMode=ExecutionMode.WRITE_NODE_PROPERTY, description="Hyperlink-Induced Topic Search (HITS) is a link analysis algorithm that rates nodes")
public final class HitsWriteProc
extends PregelWriteProc<HitsAlgorithm, Hits.HitsConfig> {
    @Procedure(name="gds.alpha.hits.write", mode=Mode.WRITE)
    @Description(value="Hyperlink-Induced Topic Search (HITS) is a link analysis algorithm that rates nodes")
    public Stream<PregelWriteResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(this.compute(graphName, configuration));
    }

    @Procedure(name="gds.alpha.hits.write.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected AbstractResultBuilder<PregelWriteResult> resultBuilder(ComputationResult<HitsAlgorithm, PregelResult, Hits.HitsConfig> computeResult, ExecutionContext executionContext) {
        int ranIterations = ((PregelResult)computeResult.result()).ranIterations();
        boolean didConverge = ((PregelResult)computeResult.result()).didConverge();
        return new PregelWriteResult.Builder().withRanIterations((long)ranIterations).didConverge(didConverge);
    }

    protected Hits.HitsConfig newConfig(String username, CypherMapWrapper config) {
        return Hits.HitsConfig.of(config);
    }

    public GraphAlgorithmFactory<HitsAlgorithm, Hits.HitsConfig> algorithmFactory() {
        return new GraphAlgorithmFactory<HitsAlgorithm, Hits.HitsConfig>(){

            public HitsAlgorithm build(Graph graph, Hits.HitsConfig configuration, ProgressTracker progressTracker) {
                return new HitsAlgorithm(graph, configuration, progressTracker);
            }

            public String taskName() {
                return HitsAlgorithm.class.getSimpleName();
            }

            public Task progressTask(Graph graph, Hits.HitsConfig configuration) {
                return Pregel.progressTask((Graph)graph, (PregelConfig)configuration);
            }

            public MemoryEstimation memoryEstimation(Hits.HitsConfig configuration) {
                Hits computation = new Hits();
                return Pregel.memoryEstimation((PregelSchema)computation.schema(configuration), (boolean)computation.reducer().isEmpty(), (boolean)configuration.isAsynchronous());
            }
        };
    }
}

