/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels.pipeline;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.nodemodels.pipeline.PipelineInfoResult;
import org.neo4j.gds.ml.pipeline.PipelineCatalog;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodeClassificationPipeline;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodeClassificationSplitConfig;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeClassificationPipelineConfigureSplitProc
extends BaseProc {
    @Procedure(name="gds.beta.pipeline.nodeClassification.configureSplit", mode=Mode.READ)
    @Description(value="Configures the split of the node classification training pipeline.")
    public Stream<PipelineInfoResult> configureSplit(@Name(value="pipelineName") String pipelineName, @Name(value="configuration") Map<String, Object> configMap) {
        NodeClassificationPipeline pipeline = (NodeClassificationPipeline)PipelineCatalog.getTyped((String)this.username(), (String)pipelineName, NodeClassificationPipeline.class);
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configMap);
        NodeClassificationSplitConfig config = NodeClassificationSplitConfig.of((CypherMapWrapper)cypherConfig);
        cypherConfig.requireOnlyKeysFrom(config.configKeys());
        pipeline.setSplitConfig(config);
        return Stream.of(new PipelineInfoResult(pipelineName, pipeline));
    }
}

