/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.train;

import java.util.List;
import org.neo4j.gds.GraphStoreAlgorithmFactory;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.ml.linkmodels.pipeline.train.LinkPredictionTrainPipelineExecutor;
import org.neo4j.gds.ml.pipeline.PipelineCatalog;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkPredictionPipeline;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkPredictionSplitConfig;
import org.neo4j.gds.ml.pipeline.linkPipeline.train.LinkPredictionTrain;
import org.neo4j.gds.ml.pipeline.linkPipeline.train.LinkPredictionTrainConfig;

public class LinkPredictionTrainPipelineAlgorithmFactory
extends GraphStoreAlgorithmFactory<LinkPredictionTrainPipelineExecutor, LinkPredictionTrainConfig> {
    private final ExecutionContext executionContext;

    public LinkPredictionTrainPipelineAlgorithmFactory(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public LinkPredictionTrainPipelineExecutor build(GraphStore graphStore, LinkPredictionTrainConfig trainConfig, ProgressTracker progressTracker) {
        LinkPredictionPipeline pipeline = (LinkPredictionPipeline)PipelineCatalog.getTyped((String)trainConfig.username(), (String)trainConfig.pipeline(), LinkPredictionPipeline.class);
        pipeline.validate();
        return new LinkPredictionTrainPipelineExecutor(pipeline, trainConfig, this.executionContext, graphStore, trainConfig.graphName(), progressTracker);
    }

    public String taskName() {
        return "Link Prediction Train Pipeline";
    }

    public Task progressTask(GraphStore graphStore, LinkPredictionTrainConfig config) {
        LinkPredictionPipeline pipeline = (LinkPredictionPipeline)PipelineCatalog.getTyped((String)config.username(), (String)config.pipeline(), LinkPredictionPipeline.class);
        return Tasks.task((String)this.taskName(), (Task)Tasks.leaf((String)"split relationships"), (Task[])new Task[]{Tasks.iterativeFixed((String)"execute node property steps", () -> List.of(Tasks.leaf((String)"step")), (int)pipeline.nodePropertySteps().size()), LinkPredictionTrain.progressTask()});
    }

    public MemoryEstimation memoryEstimation(LinkPredictionTrainConfig configuration) {
        LinkPredictionPipeline pipeline = (LinkPredictionPipeline)PipelineCatalog.getTyped((String)configuration.username(), (String)configuration.pipeline(), LinkPredictionPipeline.class);
        return LinkPredictionTrainPipelineExecutor.estimate(this.executionContext.modelCatalog(), pipeline, configuration);
    }

    public GraphDimensions estimatedGraphDimensionTransformer(GraphDimensions graphDimensions, LinkPredictionTrainConfig config) {
        LinkPredictionSplitConfig splitConfig = ((LinkPredictionPipeline)PipelineCatalog.getTyped((String)config.username(), (String)config.pipeline(), LinkPredictionPipeline.class)).splitConfig();
        return splitConfig.expectedGraphDimensions(graphDimensions.nodeCount(), graphDimensions.relCountUpperBound());
    }
}

