/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.linkmodels.pipeline.PipelineInfoResult;
import org.neo4j.gds.ml.pipeline.PipelineCatalog;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkPredictionPipeline;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkPredictionSplitConfig;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class LinkPredictionPipelineConfigureSplitProc
extends BaseProc {
    @Procedure(name="gds.beta.pipeline.linkPrediction.configureSplit", mode=Mode.READ)
    @Description(value="Configures the split of the link prediction pipeline.")
    public Stream<PipelineInfoResult> configureSplit(@Name(value="pipelineName") String pipelineName, @Name(value="configuration") Map<String, Object> configMap) {
        LinkPredictionPipeline pipeline = (LinkPredictionPipeline)PipelineCatalog.getTyped((String)this.username(), (String)pipelineName, LinkPredictionPipeline.class);
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configMap);
        LinkPredictionSplitConfig config = LinkPredictionSplitConfig.of((CypherMapWrapper)cypherConfig);
        cypherConfig.requireOnlyKeysFrom(config.configKeys());
        pipeline.setSplitConfig(config);
        return Stream.of(new PipelineInfoResult(pipelineName, pipeline));
    }
}

