/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels.pipeline.predict;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.executor.validation.AfterLoadValidation;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPredictPipelineBaseConfig;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPredictPipelineMutateConfig;
import org.neo4j.gds.utils.StringFormatting;

public final class NodeClassificationPipelineCompanion {
    static <CONFIG extends NodeClassificationPredictPipelineBaseConfig> ValidationConfiguration<CONFIG> getValidationConfig() {
        return new ValidationConfiguration<CONFIG>(){

            public List<AfterLoadValidation<CONFIG>> afterLoadValidations() {
                return List.of((graphStore, graphProjectConfig, config) -> {
                    if (config instanceof NodeClassificationPredictPipelineMutateConfig) {
                        NodeClassificationPredictPipelineMutateConfig mutateConfig = (NodeClassificationPredictPipelineMutateConfig)config;
                        NodeClassificationPipelineCompanion.validatePredictedProbabilityPropertyDoesNotExist(graphStore, mutateConfig.nodeLabelIdentifiers(graphStore), mutateConfig.predictedProbabilityProperty());
                        NodeClassificationPipelineCompanion.validateProperties(mutateConfig.mutateProperty(), mutateConfig.predictedProbabilityProperty());
                    }
                });
            }
        };
    }

    private static void validatePredictedProbabilityPropertyDoesNotExist(GraphStore graphStore, Collection<NodeLabel> filterLabels, Optional<String> maybePredictedProbabilityProperty) {
        maybePredictedProbabilityProperty.ifPresent(predictedProbabilityProperty -> {
            if (graphStore.hasNodeProperty(filterLabels, predictedProbabilityProperty)) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Node property `%s` already exists in the in-memory graph.", (Object[])new Object[]{predictedProbabilityProperty}));
            }
        });
    }

    private static void validateProperties(String property, Optional<String> maybePredictedProbabilityProperty) {
        maybePredictedProbabilityProperty.ifPresent(predictedProbabilityProperty -> {
            if (property.equals(predictedProbabilityProperty)) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Configuration parameters `%s` and `%s` must be different (both were `%s`)", (Object[])new Object[]{"mutateProperty", "predictedProbabilityProperty", predictedProbabilityProperty}));
            }
        });
    }

    private NodeClassificationPipelineCompanion() {
    }
}

