/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scaling;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.scaling.ScaleProperties;
import org.neo4j.gds.scaling.ScalePropertiesFactory;
import org.neo4j.gds.scaling.ScalePropertiesProc;
import org.neo4j.gds.scaling.ScalePropertiesStreamConfig;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.scaleProperties.stream", description="Scale node properties", executionMode=ExecutionMode.STREAM)
public class ScalePropertiesStreamProc
extends StreamProc<ScaleProperties, ScaleProperties.Result, Result, ScalePropertiesStreamConfig> {
    @Procedure(value="gds.alpha.scaleProperties.stream")
    @Description(value="Scale node properties")
    public Stream<Result> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(this.compute(graphName, configuration));
    }

    protected NodeProperties nodeProperties(ComputationResult<ScaleProperties, ScaleProperties.Result, ScalePropertiesStreamConfig> computationResult) {
        return ScalePropertiesProc.nodeProperties(computationResult);
    }

    protected ScalePropertiesStreamConfig newConfig(String username, CypherMapWrapper config) {
        return ScalePropertiesStreamConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<ScaleProperties, ScalePropertiesStreamConfig> algorithmFactory() {
        return new ScalePropertiesFactory();
    }

    protected Result streamResult(long originalNodeId, long internalNodeId, NodeProperties nodeProperties) {
        return new Result(originalNodeId, nodeProperties.doubleArrayValue(internalNodeId));
    }

    public static class Result {
        public final long nodeId;
        public final List<Double> scaledProperty;

        public Result(long nodeId, double[] scaledProperty) {
            this.nodeId = nodeId;
            this.scaledProperty = Arrays.stream(scaledProperty).boxed().collect(Collectors.toList());
        }
    }
}

