/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.traverse;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.impl.traverse.TraverseConfig;
import org.neo4j.gds.impl.walking.WalkResult;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.traverse.TraverseProc;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.bfs.stream", description="BFS is a traversal algorithm, which explores all of the neighbor nodes at the present depth prior to moving on to the nodes at the next depth level.", executionMode=ExecutionMode.STREAM)
public class TraverseProcBFS
extends TraverseProc {
    static final String DESCRIPTION = "BFS is a traversal algorithm, which explores all of the neighbor nodes at the present depth prior to moving on to the nodes at the next depth level.";

    @Procedure(name="gds.alpha.bfs.stream", mode=Mode.READ)
    @Description(value="BFS is a traversal algorithm, which explores all of the neighbor nodes at the present depth prior to moving on to the nodes at the next depth level.")
    public Stream<WalkResult> bfs(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    @Procedure(value="gds.alpha.bfs.stream.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected TraverseConfig newConfig(String username, CypherMapWrapper userInput) {
        return TraverseConfig.of((boolean)true, (CypherMapWrapper)userInput);
    }
}

