/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.traverse;

import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.impl.traverse.Traverse;
import org.neo4j.gds.impl.traverse.TraverseConfig;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.utils.InputNodeValidator;

public class TraverseFactory<CONFIG extends TraverseConfig>
extends GraphAlgorithmFactory<Traverse, CONFIG> {
    public Traverse build(Graph graphOrGraphStore, CONFIG configuration, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
        Traverse.Aggregator aggregatorFunction;
        Traverse.ExitPredicate exitFunction;
        if (!configuration.targetNodes().isEmpty()) {
            List mappedTargets = configuration.targetNodes().stream().map(arg_0 -> ((Graph)graphOrGraphStore).safeToMappedNodeId(arg_0)).collect(Collectors.toList());
            exitFunction = (s, t, w) -> mappedTargets.contains(t) ? Traverse.ExitPredicate.Result.BREAK : Traverse.ExitPredicate.Result.FOLLOW;
            aggregatorFunction = (s, t, w) -> 0.0;
        } else if (configuration.maxDepth() != -1L) {
            exitFunction = (s, t, w) -> w > (double)configuration.maxDepth() ? Traverse.ExitPredicate.Result.CONTINUE : Traverse.ExitPredicate.Result.FOLLOW;
            aggregatorFunction = (s, t, w) -> w + 1.0;
        } else {
            exitFunction = (s, t, w) -> Traverse.ExitPredicate.Result.FOLLOW;
            aggregatorFunction = (s, t, w) -> 0.0;
        }
        InputNodeValidator.validateStartNode(configuration.startNode(), graphOrGraphStore);
        configuration.targetNodes().forEach(neoId -> InputNodeValidator.validateEndNode(neoId, graphOrGraphStore));
        long mappedStartNodeId = graphOrGraphStore.toMappedNodeId(configuration.startNode());
        return configuration.isBfs() ? Traverse.bfs((Graph)graphOrGraphStore, (long)mappedStartNodeId, (Traverse.ExitPredicate)exitFunction, (Traverse.Aggregator)aggregatorFunction, (ProgressTracker)progressTracker, (AllocationTracker)allocationTracker) : Traverse.dfs((Graph)graphOrGraphStore, (long)mappedStartNodeId, (Traverse.ExitPredicate)exitFunction, (Traverse.Aggregator)aggregatorFunction, (ProgressTracker)progressTracker, (AllocationTracker)allocationTracker);
    }

    public String taskName() {
        return "Traverse";
    }

    public Task progressTask(Graph graph, CONFIG config) {
        return Tasks.leaf((String)this.taskName(), (long)graph.relationshipCount());
    }

    public MemoryEstimation memoryEstimation(CONFIG configuration) {
        MemoryEstimations.Builder builder = MemoryEstimations.builder(Traverse.class);
        builder.perNode("visited ", MemoryUsage::sizeOfBitset);
        builder.perNode("nodes", MemoryUsage::sizeOfLongArrayList);
        builder.perNode("sources", MemoryUsage::sizeOfLongArrayList);
        builder.perNode("weights", MemoryUsage::sizeOfDoubleArrayList);
        builder.perNode("resultNodes", MemoryUsage::sizeOfLongArray);
        return builder.build();
    }
}

