/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.pearson;

import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.impl.similarity.PearsonAlgorithm;
import org.neo4j.gds.impl.similarity.PearsonConfig;
import org.neo4j.gds.impl.similarity.PearsonConfigImpl;
import org.neo4j.gds.impl.similarity.SimilarityConfig;
import org.neo4j.gds.similarity.AlphaSimilarityProc;

public abstract class PearsonProc<PROC_RESULT>
extends AlphaSimilarityProc<PearsonAlgorithm, PearsonConfig, PROC_RESULT> {
    protected static final String DESCRIPTION = "Pearson-similarity is an algorithm for finding similar nodes based on the pearson correlation coefficient.";

    protected PearsonConfig newConfig(String username, CypherMapWrapper userInput) {
        return new PearsonConfigImpl(userInput);
    }

    @Override
    protected PearsonAlgorithm newAlgo(PearsonConfig config, AllocationTracker allocationTracker) {
        return new PearsonAlgorithm((SimilarityConfig)config, this.api);
    }

    @Override
    protected String taskName() {
        return "Pearson-similarity";
    }
}

