/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels.pipeline;

import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.config.ToMapConvertible;
import org.neo4j.gds.core.StringIdentifierValidations;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.ml.nodemodels.pipeline.PipelineInfoResult;
import org.neo4j.gds.ml.pipeline.PipelineCreateConfig;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodeClassificationPipeline;
import org.neo4j.gds.model.ModelConfig;

public class NodeClassificationPipelineCreate {
    public static PipelineInfoResult create(ModelCatalog modelCatalog, String username, String pipelineName) {
        StringIdentifierValidations.validateNoWhiteCharacter((String)pipelineName, (String)"pipelineName");
        NodeClassificationPipeline pipeline = new NodeClassificationPipeline();
        modelCatalog.set(NodeClassificationPipelineCreate.fromTrainingPipelineToModel(username, pipelineName, pipeline));
        return new PipelineInfoResult(pipelineName, pipeline);
    }

    @NotNull
    public static Model<Object, PipelineCreateConfig, NodeClassificationPipeline> fromTrainingPipelineToModel(String username, String pipelineName, NodeClassificationPipeline pipeline) {
        return Model.of((String)username, (String)pipelineName, (String)"Node classification training pipeline", (GraphSchema)GraphSchema.empty(), (Object)new Object(), (ModelConfig)PipelineCreateConfig.of((String)username), (ToMapConvertible)pipeline);
    }
}

