/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels;

import java.util.List;
import org.neo4j.gds.GraphStoreAlgorithmFactory;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.ml.nodemodels.NodeClassificationTrain;
import org.neo4j.gds.ml.nodemodels.pipeline.NodeClassificationPipelineCompanion;
import org.neo4j.gds.ml.nodemodels.pipeline.NodeClassificationTrainPipelineExecutor;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodeClassificationPipeline;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodeClassificationPipelineTrainConfig;

public class NodeClassificationTrainPipelineAlgorithmFactory
extends GraphStoreAlgorithmFactory<NodeClassificationTrainPipelineExecutor, NodeClassificationPipelineTrainConfig> {
    private final ExecutionContext executionContext;
    private final ModelCatalog modelCatalog;

    public NodeClassificationTrainPipelineAlgorithmFactory(ExecutionContext executionContext, ModelCatalog modelCatalog) {
        this.executionContext = executionContext;
        this.modelCatalog = modelCatalog;
    }

    public NodeClassificationTrainPipelineExecutor build(GraphStore graphStore, NodeClassificationPipelineTrainConfig configuration, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
        NodeClassificationPipeline pipeline = NodeClassificationPipelineCompanion.getNCPipeline(this.modelCatalog, configuration.pipeline(), configuration.username());
        pipeline.validateBeforeExecution(graphStore, (AlgoBaseConfig)configuration);
        return new NodeClassificationTrainPipelineExecutor(pipeline, configuration, this.executionContext, graphStore, configuration.graphName(), progressTracker);
    }

    public MemoryEstimation memoryEstimation(NodeClassificationPipelineTrainConfig configuration) {
        NodeClassificationPipeline pipeline = NodeClassificationPipelineCompanion.getNCPipeline(this.modelCatalog, configuration.pipeline(), configuration.username());
        return MemoryEstimations.builder(NodeClassificationTrainPipelineExecutor.class).add("Pipeline executor", NodeClassificationTrainPipelineExecutor.estimate(pipeline, configuration, this.modelCatalog)).build();
    }

    public String taskName() {
        return "Node Classification Train Pipeline";
    }

    public Task progressTask(GraphStore graphStore, NodeClassificationPipelineTrainConfig config) {
        NodeClassificationPipeline pipeline = NodeClassificationPipelineCompanion.getNCPipeline(this.modelCatalog, config.pipeline(), config.username());
        return Tasks.task((String)this.taskName(), (Task)Tasks.iterativeFixed((String)"execute node property steps", () -> List.of(Tasks.leaf((String)"step")), (int)pipeline.nodePropertySteps().size()), (Task[])new Task[]{NodeClassificationTrain.progressTask((int)pipeline.splitConfig().validationFolds(), (int)pipeline.trainingParameterSpace().size())});
    }
}

