/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import java.util.Map;
import java.util.Optional;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import org.HdrHistogram.ConcurrentDoubleHistogram;
import org.HdrHistogram.DoubleHistogram;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.GraphStoreAlgorithmFactory;
import org.neo4j.gds.MutateComputationResultConsumer;
import org.neo4j.gds.MutateProc;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.ml.PipelineCompanion;
import org.neo4j.gds.ml.linkmodels.LinkPredictionResult;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionPipelineCompanion;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPredictPipelineAlgorithmFactory;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPredictPipelineExecutor;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPredictPipelineMutateConfig;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.result.HistogramUtils;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.results.StandardMutateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.values.storable.NumberType;

@GdsCallable(name="gds.alpha.ml.pipeline.linkPrediction.predict.mutate", description="Predicts relationships for all non-connected node pairs based on a previously trained Link prediction pipeline.", executionMode=ExecutionMode.MUTATE_RELATIONSHIP)
public class LinkPredictionPipelineMutateProc
extends MutateProc<LinkPredictionPredictPipelineExecutor, LinkPredictionResult, MutateResult, LinkPredictionPredictPipelineMutateConfig> {
    static final String DESCRIPTION = "Predicts relationships for all non-connected node pairs based on a previously trained Link prediction pipeline.";

    @Procedure(name="gds.alpha.ml.pipeline.linkPrediction.predict.mutate", mode=Mode.READ)
    @Description(value="Predicts relationships for all non-connected node pairs based on a previously trained Link prediction pipeline.")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        PipelineCompanion.prepareTrainConfig(graphName, configuration);
        return this.mutate(this.compute(graphName, configuration));
    }

    @Procedure(name="gds.alpha.ml.pipeline.linkPrediction.predict.mutate.estimate", mode=Mode.READ)
    @Description(value="Estimates memory for predicting classes for all nodes based on a previously trained pipeline model")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        PipelineCompanion.prepareTrainConfig(graphNameOrConfiguration, algoConfiguration);
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    public ValidationConfiguration<LinkPredictionPredictPipelineMutateConfig> validationConfig() {
        return LinkPredictionPipelineCompanion.getValidationConfig();
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(ComputationResult<LinkPredictionPredictPipelineExecutor, LinkPredictionResult, LinkPredictionPredictPipelineMutateConfig> computeResult, ExecutionContext executionContext) {
        MutateResult.Builder builder = new MutateResult.Builder().withSamplingStats(((LinkPredictionResult)computeResult.result()).samplingStats());
        if (executionContext.callContext().outputFields().anyMatch(s -> s.equalsIgnoreCase("probabilityDistribution"))) {
            builder.withHistogram();
        }
        return builder;
    }

    public MutateComputationResultConsumer<LinkPredictionPredictPipelineExecutor, LinkPredictionResult, LinkPredictionPredictPipelineMutateConfig, MutateResult> computationResultConsumer() {
        return new MutateComputationResultConsumer<LinkPredictionPredictPipelineExecutor, LinkPredictionResult, LinkPredictionPredictPipelineMutateConfig, MutateResult>(this::resultBuilder){

            protected void updateGraphStore(AbstractResultBuilder<?> resultBuilder, ComputationResult<LinkPredictionPredictPipelineExecutor, LinkPredictionResult, LinkPredictionPredictPipelineMutateConfig> computationResult, ExecutionContext executionContext) {
                Graph graph = computationResult.graph();
                int concurrency = ((LinkPredictionPredictPipelineMutateConfig)computationResult.config()).concurrency();
                RelationshipsBuilder relationshipsBuilder = GraphFactory.initRelationshipsBuilder().aggregation(Aggregation.SINGLE).nodes((PartialIdMap)graph).orientation(Orientation.UNDIRECTED).addPropertyConfig(Aggregation.NONE, DefaultValue.forDouble()).concurrency(concurrency).executorService(Pools.DEFAULT).allocationTracker(LinkPredictionPipelineMutateProc.this.allocationTracker()).build();
                MutateResult.Builder resultWithHistogramBuilder = (MutateResult.Builder)resultBuilder;
                ParallelUtil.parallelStreamConsume((BaseStream)((LinkPredictionResult)computationResult.result()).stream(), (int)concurrency, stream -> stream.forEach(predictedLink -> {
                    relationshipsBuilder.addFromInternal(graph.toRootNodeId(predictedLink.sourceId()), graph.toRootNodeId(predictedLink.targetId()), predictedLink.probability());
                    resultWithHistogramBuilder.recordHistogramValue(predictedLink.probability());
                }));
                Relationships relationships = relationshipsBuilder.build();
                LinkPredictionPredictPipelineMutateConfig config = (LinkPredictionPredictPipelineMutateConfig)computationResult.config();
                try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> resultBuilder.withMutateMillis(arg_0));){
                    computationResult.graphStore().addRelationshipType(RelationshipType.of((String)config.mutateRelationshipType()), Optional.of(config.mutateProperty()), Optional.of(NumberType.FLOATING_POINT), relationships);
                }
                resultBuilder.withRelationshipsWritten(relationships.topology().elementCount());
            }
        };
    }

    protected LinkPredictionPredictPipelineMutateConfig newConfig(String username, CypherMapWrapper config) {
        return LinkPredictionPredictPipelineMutateConfig.of(username, config);
    }

    public GraphStoreAlgorithmFactory<LinkPredictionPredictPipelineExecutor, LinkPredictionPredictPipelineMutateConfig> algorithmFactory() {
        return new LinkPredictionPredictPipelineAlgorithmFactory<LinkPredictionPredictPipelineMutateConfig>(this.executionContext(), this.modelCatalog());
    }

    public AlgorithmSpec<LinkPredictionPredictPipelineExecutor, LinkPredictionResult, LinkPredictionPredictPipelineMutateConfig, Stream<MutateResult>, AlgorithmFactory<?, LinkPredictionPredictPipelineExecutor, LinkPredictionPredictPipelineMutateConfig>> withModelCatalog(ModelCatalog modelCatalog) {
        this.setModelCatalog(modelCatalog);
        return this;
    }

    public static final class MutateResult
    extends StandardMutateResult {
        public final long relationshipsWritten;
        public final Map<String, Object> probabilityDistribution;
        public final Map<String, Object> samplingStats;

        MutateResult(long preProcessingMillis, long computeMillis, long mutateMillis, long relationshipsWritten, Map<String, Object> configuration, Map<String, Object> probabilityDistribution, Map<String, Object> samplingStats) {
            super(preProcessingMillis, computeMillis, 0L, mutateMillis, configuration);
            this.relationshipsWritten = relationshipsWritten;
            this.probabilityDistribution = probabilityDistribution;
            this.samplingStats = samplingStats;
        }

        static class Builder
        extends AbstractResultBuilder<MutateResult> {
            private Map<String, Object> samplingStats = null;
            @Nullable
            private ConcurrentDoubleHistogram histogram = null;

            Builder() {
            }

            public MutateResult build() {
                return new MutateResult(this.preProcessingMillis, this.computeMillis, this.mutateMillis, this.relationshipsWritten, this.config.toMap(), this.histogram == null ? Map.of() : HistogramUtils.similaritySummary((DoubleHistogram)this.histogram), this.samplingStats);
            }

            Builder withHistogram() {
                if (this.histogram != null) {
                    return this;
                }
                this.histogram = new ConcurrentDoubleHistogram(5);
                return this;
            }

            void recordHistogramValue(double value) {
                if (this.histogram == null) {
                    return;
                }
                this.histogram.recordValue(value);
            }

            Builder withSamplingStats(Map<String, Object> samplingStats) {
                this.samplingStats = samplingStats;
                return this;
            }
        }
    }
}

