/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.write.ImmutableRelationship;
import org.neo4j.gds.core.write.Relationship;
import org.neo4j.gds.ml.linkmodels.LinkPredictionResult;
import org.neo4j.gds.ml.linkmodels.PredictedLink;
import org.neo4j.gds.ml.linkmodels.pipeline.logisticRegression.LinkLogisticRegressionData;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPrediction;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPredictPipelineBaseConfig;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionSimilarityComputer;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureExtractor;
import org.neo4j.gds.similarity.knn.ImmutableKnnContext;
import org.neo4j.gds.similarity.knn.Knn;
import org.neo4j.gds.similarity.knn.KnnBaseConfig;
import org.neo4j.gds.similarity.knn.KnnFactory;
import org.neo4j.gds.similarity.knn.NeighborFilterFactory;
import org.neo4j.gds.similarity.knn.SimilarityComputer;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class ApproximateLinkPrediction
extends LinkPrediction {
    private final KnnBaseConfig knnConfig;

    public ApproximateLinkPrediction(LinkLogisticRegressionData modelData, LinkFeatureExtractor linkFeatureExtractor, Graph graph, KnnBaseConfig knnConfig, ProgressTracker progressTracker) {
        super(modelData, linkFeatureExtractor, graph, knnConfig.concurrency(), progressTracker);
        this.knnConfig = knnConfig;
    }

    public static MemoryEstimation estimate(LinkPredictionPredictPipelineBaseConfig config) {
        KnnBaseConfig knnConfig = config.approximateConfig();
        MemoryEstimation knnEstimation = new KnnFactory().memoryEstimation(knnConfig);
        return MemoryEstimations.builder(ApproximateLinkPrediction.class).add(knnEstimation).build();
    }

    @Override
    LinkPredictionResult predictLinks(Graph graph, LinkPredictionSimilarityComputer linkPredictionSimilarityComputer) {
        Knn.Result knnResult = new Knn(graph, this.knnConfig, (SimilarityComputer)linkPredictionSimilarityComputer, (NeighborFilterFactory)new LinkPredictionSimilarityComputer.LinkFilterFactory(graph), ImmutableKnnContext.of((ExecutorService)Pools.DEFAULT, (ProgressTracker)this.progressTracker)).compute();
        return new Result(knnResult);
    }

    static class Result
    implements LinkPredictionResult {
        private final Knn.Result predictions;
        private final Map<String, Object> samplingStats;

        Result(Knn.Result knnResult) {
            this.predictions = knnResult;
            this.samplingStats = Map.of("strategy", "approximate", "linksConsidered", knnResult.nodePairsConsidered(), "ranIterations", knnResult.ranIterations(), "didConverge", knnResult.didConverge());
        }

        public Stream<PredictedLink> stream() {
            return this.predictions.streamSimilarityResult().map(i -> PredictedLink.of((long)i.sourceNodeId(), (long)i.targetNodeId(), (double)i.similarity));
        }

        public Stream<Relationship> relationshipStream() {
            return this.predictions.streamSimilarityResult().map(i -> ImmutableRelationship.of((long)i.node1, (long)i.node2, (Value[])new Value[]{Values.doubleValue((double)i.similarity)}));
        }

        public Map<String, Object> samplingStats() {
            return this.samplingStats;
        }
    }
}

