/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.config.ToMapConvertible;
import org.neo4j.gds.core.StringIdentifierValidations;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.ml.linkmodels.pipeline.PipelineInfoResult;
import org.neo4j.gds.ml.pipeline.PipelineCreateConfig;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkPredictionPipeline;
import org.neo4j.gds.model.ModelConfig;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class LinkPredictionPipelineCreateProc
extends BaseProc {
    @Procedure(name="gds.alpha.ml.pipeline.linkPrediction.create", mode=Mode.READ)
    @Description(value="Creates a link prediction pipeline in the model catalog.")
    public Stream<PipelineInfoResult> create(@Name(value="pipelineName") String input) {
        String pipelineName = StringIdentifierValidations.validateNoWhiteCharacter((String)input, (String)"pipelineName");
        Model model = Model.of((String)this.username(), (String)pipelineName, (String)"Link prediction training pipeline", (GraphSchema)GraphSchema.empty(), (Object)new Object(), (ModelConfig)PipelineCreateConfig.of((String)this.username()), (ToMapConvertible)new LinkPredictionPipeline());
        this.modelCatalog().set(model);
        return Stream.of(new PipelineInfoResult(pipelineName, (LinkPredictionPipeline)model.customInfo()));
    }
}

