/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionPipelineCompanion;
import org.neo4j.gds.ml.linkmodels.pipeline.PipelineInfoResult;
import org.neo4j.gds.ml.pipeline.FeatureStep;
import org.neo4j.gds.ml.pipeline.NodePropertyStepFactory;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureStepFactory;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkPredictionPipeline;
import org.neo4j.gds.ml.pipeline.linkPipeline.linkfunctions.LinkFeatureStepConfiguration;
import org.neo4j.gds.ml.pipeline.linkPipeline.linkfunctions.LinkFeatureStepConfigurationImpl;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class LinkPredictionPipelineAddStepProcs
extends BaseProc {
    @Procedure(name="gds.alpha.ml.pipeline.linkPrediction.addNodeProperty", mode=Mode.READ)
    @Description(value="Add a node property step to an existing link prediction pipeline.")
    public Stream<PipelineInfoResult> addNodeProperty(@Name(value="pipelineName") String pipelineName, @Name(value="procedureName") String taskName, @Name(value="procedureConfiguration") Map<String, Object> procedureConfig) {
        LinkPredictionPipeline pipeline = LinkPredictionPipelineCompanion.getLPPipeline(this.modelCatalog(), pipelineName, this.username());
        this.validateRelationshipProperty(pipeline, procedureConfig);
        pipeline.addNodePropertyStep(NodePropertyStepFactory.createNodePropertyStep((String)this.executionContext().username(), (String)taskName, procedureConfig));
        return Stream.of(new PipelineInfoResult(pipelineName, pipeline));
    }

    @Procedure(name="gds.alpha.ml.pipeline.linkPrediction.addFeature", mode=Mode.READ)
    @Description(value="Add a feature step to an existing link prediction pipeline.")
    public Stream<PipelineInfoResult> addFeature(@Name(value="pipelineName") String pipelineName, @Name(value="featureType") String featureType, @Name(value="configuration") Map<String, Object> config) {
        LinkPredictionPipeline pipeline = LinkPredictionPipelineCompanion.getLPPipeline(this.modelCatalog(), pipelineName, this.username());
        LinkFeatureStepConfigurationImpl parsedConfig = new LinkFeatureStepConfigurationImpl(CypherMapWrapper.create(config));
        pipeline.addFeatureStep((FeatureStep)LinkFeatureStepFactory.create((String)featureType, (LinkFeatureStepConfiguration)parsedConfig));
        return Stream.of(new PipelineInfoResult(pipelineName, pipeline));
    }

    private void validateRelationshipProperty(LinkPredictionPipeline pipeline, Map<String, Object> procedureConfig) {
        String property;
        if (!procedureConfig.containsKey("relationshipWeightProperty")) {
            return;
        }
        Optional maybeRelationshipProperty = pipeline.relationshipWeightProperty();
        if (maybeRelationshipProperty.isEmpty()) {
            return;
        }
        String relationshipProperty = (String)maybeRelationshipProperty.get();
        if (relationshipProperty.equals(property = (String)procedureConfig.get("relationshipWeightProperty"))) {
            return;
        }
        String tasks = ((List)pipeline.tasksByRelationshipProperty().get(relationshipProperty)).stream().map(s -> "`" + s + "`").collect(Collectors.joining(", "));
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Node property steps added to a pipeline may not have different non-null values for `%s`. Pipeline already contains tasks %s which use the value `%s`.", (Object[])new Object[]{"relationshipWeightProperty", tasks, relationshipProperty}));
    }
}

