/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.WriteStreamOfRelationshipsProc;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.ml.linkmodels.ExhaustiveLinkPredictionResult;
import org.neo4j.gds.ml.linkmodels.LinkPredictionPredict;
import org.neo4j.gds.ml.linkmodels.LinkPredictionPredictCompanion;
import org.neo4j.gds.ml.linkmodels.LinkPredictionPredictFactory;
import org.neo4j.gds.ml.linkmodels.LinkPredictionPredictWriteConfig;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.results.StandardWriteRelationshipsResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.ml.linkPrediction.predict.write", description="Predicts relationships for all node pairs based on a previously trained link prediction model.", executionMode=ExecutionMode.WRITE_RELATIONSHIP)
public class LinkPredictionPredictWriteProc
extends WriteStreamOfRelationshipsProc<LinkPredictionPredict, ExhaustiveLinkPredictionResult, StandardWriteRelationshipsResult, LinkPredictionPredictWriteConfig> {
    @Procedure(name="gds.alpha.ml.linkPrediction.predict.write", mode=Mode.WRITE)
    @Description(value="Predicts relationships for all node pairs based on a previously trained link prediction model.")
    public Stream<StandardWriteRelationshipsResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(this.compute(graphName, configuration));
    }

    @Procedure(name="gds.alpha.ml.linkPrediction.predict.write.estimate", mode=Mode.READ)
    @Description(value="Estimates memory for applying a linkPrediction model")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    public ValidationConfiguration<LinkPredictionPredictWriteConfig> validationConfig() {
        return LinkPredictionPredictCompanion.getValidationConfig();
    }

    public AlgorithmSpec<LinkPredictionPredict, ExhaustiveLinkPredictionResult, LinkPredictionPredictWriteConfig, Stream<StandardWriteRelationshipsResult>, AlgorithmFactory<?, LinkPredictionPredict, LinkPredictionPredictWriteConfig>> withModelCatalog(ModelCatalog modelCatalog) {
        this.setModelCatalog(modelCatalog);
        return this;
    }

    protected LinkPredictionPredictWriteConfig newConfig(String username, CypherMapWrapper config) {
        return LinkPredictionPredictWriteConfig.of((String)username, (CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<LinkPredictionPredict, LinkPredictionPredictWriteConfig> algorithmFactory() {
        return new LinkPredictionPredictFactory(this.modelCatalog());
    }

    protected AbstractResultBuilder<StandardWriteRelationshipsResult> resultBuilder(ComputationResult<LinkPredictionPredict, ExhaustiveLinkPredictionResult, LinkPredictionPredictWriteConfig> computeResult) {
        return new StandardWriteRelationshipsResult.Builder();
    }
}

