/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.centrality;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.centrality.CentralityScore;
import org.neo4j.gds.centrality.ClosenessCentralityProc;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.impl.closeness.ClosenessCentralityConfig;
import org.neo4j.gds.impl.closeness.MSClosenessCentrality;
import org.neo4j.gds.result.AbstractCentralityResultBuilder;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.closeness.write", description="Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class ClosenessCentralityWriteProc
extends ClosenessCentralityProc<CentralityScore.Stats> {
    @Procedure(value="gds.alpha.closeness.write", mode=Mode.WRITE)
    @Description(value="Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.")
    public Stream<CentralityScore.Stats> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    public ComputationResultConsumer<MSClosenessCentrality, MSClosenessCentrality, ClosenessCentralityConfig, Stream<CentralityScore.Stats>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            MSClosenessCentrality algorithm = (MSClosenessCentrality)computationResult.algorithm();
            ClosenessCentralityConfig config = (ClosenessCentralityConfig)computationResult.config();
            Graph graph = computationResult.graph();
            CentralityScore.Stats.Builder builder = new CentralityScore.Stats.Builder(this.callContext, config.concurrency());
            builder.withNodeCount(graph.nodeCount()).withConfig((AlgoBaseConfig)config).withComputeMillis(computationResult.computeMillis()).withPreProcessingMillis(computationResult.preProcessingMillis());
            if (graph.isEmpty()) {
                graph.release();
                return Stream.of((CentralityScore.Stats)builder.build());
            }
            builder.withCentralityFunction(arg_0 -> ((HugeDoubleArray)algorithm.getCentrality()).get(arg_0));
            try (ProgressTimer ignore = ProgressTimer.start(arg_0 -> ((AbstractCentralityResultBuilder)builder).withWriteMillis(arg_0));){
                int writeConcurrency = ((ClosenessCentralityConfig)computationResult.config()).writeConcurrency();
                TaskProgressTracker progressTracker = new TaskProgressTracker(NodePropertyExporter.baseTask((String)"ClosenessCentrality", (long)graph.nodeCount()), this.log, writeConcurrency, this.taskRegistryFactory);
                NodePropertyExporter exporter = this.nodePropertyExporterBuilder.withIdMap((IdMap)graph).withTerminationFlag(algorithm.getTerminationFlag()).withProgressTracker((ProgressTracker)progressTracker).parallel(Pools.DEFAULT, writeConcurrency).build();
                algorithm.export(config.writeProperty(), exporter, (ProgressTracker)progressTracker);
            }
            graph.release();
            return Stream.of((CentralityScore.Stats)builder.build());
        };
    }
}

