/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.traverse;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.impl.traverse.TraverseConfig;
import org.neo4j.gds.impl.walking.WalkResult;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.traverse.TraverseProc;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.dfs.stream", description="DFS is a traversal algorithm, which explores all of the children nodes of the present node prior to moving on to the next neighbour.", executionMode=ExecutionMode.STREAM)
public class TraverseProcDFS
extends TraverseProc {
    static final String DESCRIPTION = "DFS is a traversal algorithm, which explores all of the children nodes of the present node prior to moving on to the next neighbour.";

    @Procedure(name="gds.alpha.dfs.stream", mode=Mode.READ)
    @Description(value="DFS is a traversal algorithm, which explores all of the children nodes of the present node prior to moving on to the next neighbour.")
    public Stream<WalkResult> dfs(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    @Procedure(value="gds.alpha.dfs.stream.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected TraverseConfig newConfig(String username, CypherMapWrapper userInput) {
        return TraverseConfig.of((boolean)false, (CypherMapWrapper)userInput);
    }
}

