/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.traverse;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.impl.traverse.Traverse;
import org.neo4j.gds.impl.traverse.TraverseConfig;
import org.neo4j.gds.impl.walking.WalkResult;
import org.neo4j.gds.paths.PathFactory;
import org.neo4j.gds.traverse.TraverseFactory;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;

public abstract class TraverseProc
extends AlgoBaseProc<Traverse, Traverse, TraverseConfig, WalkResult> {
    private static final RelationshipType NEXT = RelationshipType.withName((String)"NEXT");

    public GraphAlgorithmFactory<Traverse, TraverseConfig> algorithmFactory() {
        return new TraverseFactory<TraverseConfig>();
    }

    public ComputationResultConsumer<Traverse, Traverse, TraverseConfig, Stream<WalkResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            if (computationResult.graph().isEmpty()) {
                return Stream.empty();
            }
            Traverse traverse = (Traverse)computationResult.algorithm();
            long[] nodes = traverse.resultNodes();
            List nodeList = Arrays.stream(nodes).boxed().collect(Collectors.toList());
            return Stream.of(new WalkResult(nodes, PathFactory.create((Transaction)this.transaction.internalTransaction(), nodeList, (RelationshipType)NEXT)));
        };
    }
}

