/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.ann;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.HdrHistogram.DoubleHistogram;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.impl.similarity.ApproxNearestNeighborsAlgorithm;
import org.neo4j.gds.impl.similarity.ApproximateNearestNeighborsConfig;
import org.neo4j.gds.impl.similarity.Computations;
import org.neo4j.gds.impl.similarity.SimilarityAlgorithmResult;
import org.neo4j.gds.impl.similarity.SimilarityInput;
import org.neo4j.gds.results.SimilarityResult;
import org.neo4j.gds.similarity.SimilarityExporter;
import org.neo4j.gds.similarity.ann.ApproxNearestNeighborsProc;
import org.neo4j.gds.similarity.ann.ApproxSimilaritySummaryResult;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.ml.ann.write", description="The Approximate Nearest Neighbors algorithm constructs a k-Nearest Neighbors graph for a set of objects based on a provided similarity function.", executionMode=ExecutionMode.WRITE_RELATIONSHIP)
public class ApproxNearestNeighborsWriteProc
extends ApproxNearestNeighborsProc<ApproxSimilaritySummaryResult> {
    @Procedure(name="gds.alpha.ml.ann.write", mode=Mode.WRITE)
    @Description(value="The Approximate Nearest Neighbors algorithm constructs a k-Nearest Neighbors graph for a set of objects based on a provided similarity function.")
    public Stream<ApproxSimilaritySummaryResult> annWrite(@Name(value="configuration") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute("  SIM-NULL-GRAPH", configuration);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    public ComputationResultConsumer<ApproxNearestNeighborsAlgorithm<SimilarityInput>, SimilarityAlgorithmResult, ApproximateNearestNeighborsConfig, Stream<ApproxSimilaritySummaryResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            ApproximateNearestNeighborsConfig config = (ApproximateNearestNeighborsConfig)computationResult.config();
            SimilarityAlgorithmResult result = (SimilarityAlgorithmResult)computationResult.result();
            assert (result != null);
            if (result.isEmpty()) {
                return this.emptyStreamResult(result, config, (ApproxNearestNeighborsAlgorithm<SimilarityInput>)((ApproxNearestNeighborsAlgorithm)computationResult.algorithm()));
            }
            return this.writeAndAggregateANNResults(result, config, (ApproxNearestNeighborsAlgorithm<SimilarityInput>)((ApproxNearestNeighborsAlgorithm)computationResult.algorithm()));
        };
    }

    private Stream<ApproxSimilaritySummaryResult> emptyStreamResult(SimilarityAlgorithmResult result, ApproximateNearestNeighborsConfig config, @Nullable ApproxNearestNeighborsAlgorithm<SimilarityInput> algorithm) {
        return Stream.of(ApproxSimilaritySummaryResult.from(result.nodes(), 0L, result.computations().map(Computations::count).orElse(-1L), config.writeRelationshipType(), config.writeProperty(), algorithm.iterations(), new DoubleHistogram(5)));
    }

    private Stream<ApproxSimilaritySummaryResult> writeAndAggregateANNResults(SimilarityAlgorithmResult algoResult, ApproximateNearestNeighborsConfig config, @Nullable ApproxNearestNeighborsAlgorithm<SimilarityInput> algorithm) {
        AtomicLong similarityPairs = new AtomicLong();
        DoubleHistogram histogram = new DoubleHistogram(5);
        Consumer<SimilarityResult> recorder = result -> {
            result.record(histogram);
            similarityPairs.getAndIncrement();
        };
        SimilarityExporter similarityExporter = new SimilarityExporter(TransactionContext.of((GraphDatabaseAPI)this.api, (Transaction)this.procedureTransaction), config.writeRelationshipType(), config.writeProperty(), algorithm.getTerminationFlag());
        similarityExporter.export(algoResult.stream().peek(recorder), config.writeBatchSize());
        return Stream.of(ApproxSimilaritySummaryResult.from(algoResult.nodes(), similarityPairs.get(), algoResult.computations().map(Computations::count).orElse(-1L), config.writeRelationshipType(), config.writeProperty(), algorithm.iterations(), histogram));
    }
}

