/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity;

import java.util.Map;
import org.neo4j.gds.NodeProjections;
import org.neo4j.gds.RelationshipProjections;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.ImmutableGraphProjectFromStoreConfig;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.executor.ProcConfigParser;
import org.neo4j.gds.impl.similarity.SimilarityConfig;
import org.neo4j.gds.similarity.AlphaSimilarityProc;
import org.neo4j.gds.similarity.nil.NullGraphStore;
import org.neo4j.kernel.database.NamedDatabaseId;

public class AlphaSimilarityProcConfigParser<CONFIG extends SimilarityConfig>
implements ProcConfigParser<CONFIG> {
    private final String username;
    private final ProcConfigParser<CONFIG> configParser;
    private final NamedDatabaseId databaseId;

    AlphaSimilarityProcConfigParser(String username, ProcConfigParser<CONFIG> configParser, NamedDatabaseId databaseId) {
        this.username = username;
        this.configParser = configParser;
        this.databaseId = databaseId;
    }

    public CONFIG processInput(Map<String, Object> configuration) {
        String graphName = "  SIM-NULL-GRAPH";
        configuration.remove("nodeQuery");
        configuration.remove("relationshipQuery");
        configuration.remove("nodeProjection");
        configuration.remove("relationshipProjection");
        GraphStoreCatalog.set((GraphProjectConfig)ImmutableGraphProjectFromStoreConfig.of((String)this.username, (String)graphName, (NodeProjections)NodeProjections.ALL, (RelationshipProjections)RelationshipProjections.ALL), (GraphStore)new NullGraphStore(this.databaseId));
        try {
            return (CONFIG)((SimilarityConfig)this.configParser.processInput(configuration));
        }
        catch (RuntimeException e) {
            AlphaSimilarityProc.removeGraph(this.username, this.databaseId);
            throw e;
        }
    }
}

