/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.HdrHistogram.DoubleHistogram;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.loading.CatalogRequest;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ProcConfigParser;
import org.neo4j.gds.impl.similarity.Computations;
import org.neo4j.gds.impl.similarity.SimilarityAlgorithm;
import org.neo4j.gds.impl.similarity.SimilarityAlgorithmResult;
import org.neo4j.gds.impl.similarity.SimilarityConfig;
import org.neo4j.gds.results.SimilarityResult;
import org.neo4j.gds.similarity.AlphaSimilarityProcConfigParser;
import org.neo4j.gds.similarity.AlphaSimilarityStatsResult;
import org.neo4j.gds.similarity.AlphaSimilaritySummaryResult;
import org.neo4j.gds.similarity.SimilarityExporter;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public abstract class AlphaSimilarityProc<ALGO extends SimilarityAlgorithm<ALGO, ?>, CONFIG extends SimilarityConfig, PROC_RESULT>
extends AlgoBaseProc<ALGO, SimilarityAlgorithmResult, CONFIG, PROC_RESULT> {
    public static final String SIMILARITY_FAKE_GRAPH_NAME = "  SIM-NULL-GRAPH";

    protected Stream<SimilarityResult> stream(Map<String, Object> configuration) {
        ComputationResult compute = this.compute(SIMILARITY_FAKE_GRAPH_NAME, configuration);
        return (Stream)this.streamResultConsumer().consume(compute, this.executionContext());
    }

    protected ComputationResultConsumer<ALGO, SimilarityAlgorithmResult, CONFIG, Stream<SimilarityResult>> streamResultConsumer() {
        return (computationResult, executionContext) -> {
            SimilarityAlgorithmResult result = (SimilarityAlgorithmResult)computationResult.result();
            assert (result != null);
            return result.stream();
        };
    }

    protected Stream<AlphaSimilaritySummaryResult> write(Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(SIMILARITY_FAKE_GRAPH_NAME, configuration);
        return (Stream)this.writeResultConsumer().consume(computationResult, this.executionContext());
    }

    protected ComputationResultConsumer<ALGO, SimilarityAlgorithmResult, CONFIG, Stream<AlphaSimilaritySummaryResult>> writeResultConsumer() {
        return (computationResult, executionContext) -> {
            SimilarityConfig config = (SimilarityConfig)computationResult.config();
            SimilarityAlgorithmResult result = (SimilarityAlgorithmResult)computationResult.result();
            assert (result != null);
            if (result.isEmpty()) {
                return this.emptyStream(config.writeRelationshipType(), config.writeProperty());
            }
            return this.writeAndAggregateResults(result, config, ((SimilarityAlgorithm)computationResult.algorithm()).getTerminationFlag());
        };
    }

    protected Stream<AlphaSimilarityStatsResult> stats(Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(SIMILARITY_FAKE_GRAPH_NAME, configuration);
        return (Stream)this.statsResultConsumer().consume(computationResult, this.executionContext());
    }

    protected ComputationResultConsumer<ALGO, SimilarityAlgorithmResult, CONFIG, Stream<AlphaSimilarityStatsResult>> statsResultConsumer() {
        return (computationResult, executionContext) -> {
            SimilarityAlgorithmResult result = (SimilarityAlgorithmResult)computationResult.result();
            assert (result != null);
            if (result.isEmpty()) {
                return Stream.of(AlphaSimilarityStatsResult.from(0L, 0L, 0L, new AtomicLong(0L), -1L, new DoubleHistogram(5)));
            }
            AtomicLong similarityPairs = new AtomicLong();
            DoubleHistogram histogram = new DoubleHistogram(5);
            result.stream().forEach(recorder -> {
                recorder.record(histogram);
                similarityPairs.getAndIncrement();
            });
            return Stream.of(AlphaSimilarityStatsResult.from(result.nodes(), result.sourceIdsLength(), result.targetIdsLength(), similarityPairs, result.computations().map(Computations::count).orElse(-1L), histogram));
        };
    }

    protected abstract ALGO newAlgo(CONFIG var1, AllocationTracker var2);

    protected abstract String taskName();

    public final GraphAlgorithmFactory<ALGO, CONFIG> algorithmFactory() {
        return new GraphAlgorithmFactory<ALGO, CONFIG>(){

            public String taskName() {
                return AlphaSimilarityProc.this.taskName();
            }

            public ALGO build(Graph graph, CONFIG configuration, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
                AlphaSimilarityProc.removeGraph(AlphaSimilarityProc.this.username(), AlphaSimilarityProc.this.databaseId());
                return AlphaSimilarityProc.this.newAlgo(configuration, allocationTracker);
            }
        };
    }

    public ProcConfigParser<CONFIG> configParser() {
        return new AlphaSimilarityProcConfigParser(this.username(), super.configParser(), this.databaseId());
    }

    static void removeGraph(String username, NamedDatabaseId databaseId) {
        GraphStoreCatalog.remove((CatalogRequest)CatalogRequest.of((String)username, (NamedDatabaseId)databaseId), (String)SIMILARITY_FAKE_GRAPH_NAME, gsc -> {}, (boolean)true);
    }

    private Stream<AlphaSimilaritySummaryResult> emptyStream(String writeRelationshipType, String writeProperty) {
        return Stream.of(AlphaSimilaritySummaryResult.from(0L, 0L, 0L, new AtomicLong(0L), -1L, writeRelationshipType, writeProperty, new DoubleHistogram(5)));
    }

    private Stream<AlphaSimilaritySummaryResult> writeAndAggregateResults(SimilarityAlgorithmResult algoResult, CONFIG config, TerminationFlag terminationFlag) {
        AtomicLong similarityPairs = new AtomicLong();
        DoubleHistogram histogram = new DoubleHistogram(5);
        Consumer<SimilarityResult> recorder = result -> {
            result.record(histogram);
            similarityPairs.getAndIncrement();
        };
        SimilarityExporter similarityExporter = new SimilarityExporter(TransactionContext.of((GraphDatabaseAPI)this.api, (Transaction)this.procedureTransaction), config.writeRelationshipType(), config.writeProperty(), terminationFlag);
        similarityExporter.export(algoResult.stream().peek(recorder), config.writeBatchSize());
        return Stream.of(AlphaSimilaritySummaryResult.from(algoResult.nodes(), algoResult.sourceIdsLength(), algoResult.targetIdsLength(), similarityPairs, algoResult.computations().map(Computations::count).orElse(-1L), config.writeRelationshipType(), config.writeProperty(), histogram));
    }
}

