/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.shortestpath;

import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.NodePropertiesWriter;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.impl.ShortestPathDeltaStepping;
import org.neo4j.gds.shortestpath.ShortestPathDeltaSteppingConfig;
import org.neo4j.gds.utils.InputNodeValidator;

public abstract class ShortestPathDeltaSteppingProc<PROC_RESULT>
extends NodePropertiesWriter<ShortestPathDeltaStepping, ShortestPathDeltaStepping, ShortestPathDeltaSteppingConfig, PROC_RESULT> {
    protected static final String DESCRIPTION = "Delta-Stepping is a non-negative single source shortest paths (NSSSP) algorithm.";

    protected ShortestPathDeltaSteppingConfig newConfig(String username, CypherMapWrapper config) {
        return ShortestPathDeltaSteppingConfig.of(config);
    }

    public GraphAlgorithmFactory<ShortestPathDeltaStepping, ShortestPathDeltaSteppingConfig> algorithmFactory() {
        return new GraphAlgorithmFactory<ShortestPathDeltaStepping, ShortestPathDeltaSteppingConfig>(){

            public String taskName() {
                return "ShortestPathDeltaStepping";
            }

            public ShortestPathDeltaStepping build(Graph graph, ShortestPathDeltaSteppingConfig configuration, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
                InputNodeValidator.validateStartNode(configuration.startNode(), graph);
                return new ShortestPathDeltaStepping(graph, configuration.startNode(), configuration.delta(), progressTracker);
            }
        };
    }
}

