/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scc;

import java.util.Map;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.impl.scc.SccAlgorithm;
import org.neo4j.gds.impl.scc.SccConfig;
import org.neo4j.gds.scc.SccProc;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.scc.stream", description="The SCC algorithm finds sets of connected nodes in an directed graph, where all nodes in the same set form a connected component.", executionMode=ExecutionMode.STREAM)
public class SccStreamProc
extends SccProc<SccAlgorithm.StreamResult> {
    @Procedure(value="gds.alpha.scc.stream", mode=Mode.READ)
    @Description(value="The SCC algorithm finds sets of connected nodes in an directed graph, where all nodes in the same set form a connected component.")
    public Stream<SccAlgorithm.StreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    public ComputationResultConsumer<SccAlgorithm, HugeLongArray, SccConfig, Stream<SccAlgorithm.StreamResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            AllocationTracker allocationTracker = this.allocationTracker();
            Graph graph = computationResult.graph();
            HugeLongArray components = (HugeLongArray)computationResult.result();
            if (graph.isEmpty()) {
                graph.release();
                return Stream.empty();
            }
            this.log.info("Scc: overall memory usage: %s", new Object[]{allocationTracker.getUsageString()});
            graph.release();
            return LongStream.range(0L, graph.nodeCount()).filter(i -> components.get(i) != -1L).mapToObj(i -> new SccAlgorithm.StreamResult(graph.toOriginalNodeId(i), components.get(i)));
        };
    }
}

