/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scaling;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.MutatePropertyProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.StandardMutateResult;
import org.neo4j.gds.scaling.ScaleProperties;
import org.neo4j.gds.scaling.ScalePropertiesFactory;
import org.neo4j.gds.scaling.ScalePropertiesMutateConfig;
import org.neo4j.gds.scaling.ScalePropertiesProc;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.scaleProperties.mutate", description="Scale node properties", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY)
public class ScalePropertiesMutateProc
extends MutatePropertyProc<ScaleProperties, ScaleProperties.Result, MutateResult, ScalePropertiesMutateConfig> {
    @Procedure(value="gds.alpha.scaleProperties.mutate")
    @Description(value="Scale node properties")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.mutate(this.compute(graphName, configuration));
    }

    protected NodeProperties nodeProperties(ComputationResult<ScaleProperties, ScaleProperties.Result, ScalePropertiesMutateConfig> computationResult) {
        return ScalePropertiesProc.nodeProperties(computationResult);
    }

    protected ScalePropertiesMutateConfig newConfig(String username, CypherMapWrapper config) {
        return ScalePropertiesMutateConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<ScaleProperties, ScalePropertiesMutateConfig> algorithmFactory() {
        return new ScalePropertiesFactory();
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(ComputationResult<ScaleProperties, ScaleProperties.Result, ScalePropertiesMutateConfig> computeResult, ExecutionContext executionContext) {
        return new MutateResult.Builder();
    }

    public static final class MutateResult
    extends StandardMutateResult {
        public final long nodePropertiesWritten;

        MutateResult(long preProcessingMillis, long computeMillis, long mutateMillis, long nodePropertiesWritten, Map<String, Object> configuration) {
            super(preProcessingMillis, computeMillis, 0L, mutateMillis, configuration);
            this.nodePropertiesWritten = nodePropertiesWritten;
        }

        static class Builder
        extends AbstractResultBuilder<MutateResult> {
            Builder() {
            }

            public MutateResult build() {
                return new MutateResult(this.preProcessingMillis, this.computeMillis, this.mutateMillis, this.nodePropertiesWritten, this.config.toMap());
            }
        }
    }
}

