/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.beta.pregel.Pregel;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.PregelSchema;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.pregel.Hits;
import org.neo4j.gds.pregel.HitsAlgorithm;
import org.neo4j.gds.pregel.proc.PregelStreamProc;
import org.neo4j.gds.pregel.proc.PregelStreamResult;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.hits.stream", executionMode=ExecutionMode.STREAM, description="Hyperlink-Induced Topic Search (HITS) is a link analysis algorithm that rates nodes")
public final class HitsStreamProc
extends PregelStreamProc<HitsAlgorithm, Hits.HitsConfig> {
    @Procedure(name="gds.alpha.hits.stream", mode=Mode.READ)
    @Description(value="Hyperlink-Induced Topic Search (HITS) is a link analysis algorithm that rates nodes")
    public Stream<PregelStreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(this.compute(graphName, configuration));
    }

    @Procedure(name="gds.alpha.hits.stream.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected PregelStreamResult streamResult(long originalNodeId, long internalNodeId, NodeProperties nodeProperties) {
        throw new UnsupportedOperationException();
    }

    protected Hits.HitsConfig newConfig(String username, CypherMapWrapper config) {
        return Hits.HitsConfig.of(config);
    }

    public GraphAlgorithmFactory<HitsAlgorithm, Hits.HitsConfig> algorithmFactory() {
        return new GraphAlgorithmFactory<HitsAlgorithm, Hits.HitsConfig>(){

            public HitsAlgorithm build(Graph graph, Hits.HitsConfig configuration, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
                return new HitsAlgorithm(graph, configuration, allocationTracker, progressTracker);
            }

            public String taskName() {
                return HitsAlgorithm.class.getSimpleName();
            }

            public Task progressTask(Graph graph, Hits.HitsConfig configuration) {
                return Pregel.progressTask((Graph)graph, (PregelConfig)configuration);
            }

            public MemoryEstimation memoryEstimation(Hits.HitsConfig configuration) {
                Hits computation = new Hits();
                return Pregel.memoryEstimation((PregelSchema)computation.schema(configuration), (boolean)computation.reducer().isPresent(), (boolean)configuration.isAsynchronous());
            }
        };
    }
}

