/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels.pipeline.predict;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphStoreAlgorithmFactory;
import org.neo4j.gds.WriteProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.DoubleArrayNodeProperties;
import org.neo4j.gds.api.nodeproperties.LongNodeProperties;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.write.NodeProperty;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.AfterLoadValidation;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeClassificationResult;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPipelineCompanion;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPredictPipelineAlgorithmFactory;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPredictPipelineExecutor;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPredictPipelineWriteConfig;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.results.StandardWriteResult;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.ml.pipeline.nodeClassification.predict.write", description="Predicts classes for all nodes based on a previously trained pipeline model", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class NodeClassificationPipelineWriteProc
extends WriteProc<NodeClassificationPredictPipelineExecutor, NodeClassificationResult, WriteResult, NodeClassificationPredictPipelineWriteConfig> {
    @Context
    public ModelCatalog modelCatalog;

    @Procedure(name="gds.alpha.ml.pipeline.nodeClassification.predict.write", mode=Mode.WRITE)
    @Description(value="Predicts classes for all nodes based on a previously trained pipeline model")
    public Stream<WriteResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        NodeClassificationPipelineCompanion.prepareTrainConfig(graphName, configuration);
        return this.write(this.compute(graphName, configuration));
    }

    @Procedure(name="gds.alpha.ml.pipeline.nodeClassification.predict.write.estimate", mode=Mode.READ)
    @Description(value="Estimates memory for predicting classes for all nodes based on a previously trained pipeline model")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        NodeClassificationPipelineCompanion.prepareTrainConfig(graphNameOrConfiguration, algoConfiguration);
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    public ValidationConfiguration<NodeClassificationPredictPipelineWriteConfig> validationConfig() {
        return new ValidationConfiguration<NodeClassificationPredictPipelineWriteConfig>(){

            public List<AfterLoadValidation<NodeClassificationPredictPipelineWriteConfig>> afterLoadValidations() {
                return List.of((graphStore, graphProjectConfig, config) -> config.predictedProbabilityProperty().ifPresent(predictedProbabilityProperty -> {
                    if (config.writeProperty().equals(predictedProbabilityProperty)) {
                        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Configuration parameters `%s` and `%s` must be different (both were `%s`)", (Object[])new Object[]{"writeProperty", "predictedProbabilityProperty", predictedProbabilityProperty}));
                    }
                }));
            }
        };
    }

    protected List<NodeProperty> nodePropertyList(ComputationResult<NodeClassificationPredictPipelineExecutor, NodeClassificationResult, NodeClassificationPredictPipelineWriteConfig> computationResult) {
        NodeClassificationPredictPipelineWriteConfig config = (NodeClassificationPredictPipelineWriteConfig)computationResult.config();
        String writeProperty = config.writeProperty();
        NodeClassificationResult result = (NodeClassificationResult)computationResult.result();
        LongNodeProperties classProperties = result.predictedClasses().asNodeProperties();
        ArrayList<NodeProperty> nodeProperties = new ArrayList<NodeProperty>();
        nodeProperties.add(NodeProperty.of((String)writeProperty, (NodeProperties)classProperties));
        result.predictedProbabilities().ifPresent(probabilityProperties -> {
            DoubleArrayNodeProperties properties = new DoubleArrayNodeProperties((ComputationResult)computationResult, (HugeObjectArray)probabilityProperties){
                final /* synthetic */ ComputationResult val$computationResult;
                final /* synthetic */ HugeObjectArray val$probabilityProperties;
                {
                    this.val$computationResult = computationResult;
                    this.val$probabilityProperties = hugeObjectArray;
                }

                public long size() {
                    return this.val$computationResult.graph().nodeCount();
                }

                public double[] doubleArrayValue(long nodeId) {
                    return (double[])this.val$probabilityProperties.get(nodeId);
                }
            };
            nodeProperties.add(NodeProperty.of((String)config.predictedProbabilityProperty().orElseThrow(), (NodeProperties)properties));
        });
        return nodeProperties;
    }

    protected AbstractResultBuilder<WriteResult> resultBuilder(ComputationResult<NodeClassificationPredictPipelineExecutor, NodeClassificationResult, NodeClassificationPredictPipelineWriteConfig> computeResult, ExecutionContext executionContext) {
        return new WriteResult.Builder();
    }

    protected NodeClassificationPredictPipelineWriteConfig newConfig(String username, CypherMapWrapper config) {
        return NodeClassificationPredictPipelineWriteConfig.of(username, config);
    }

    public GraphStoreAlgorithmFactory<NodeClassificationPredictPipelineExecutor, NodeClassificationPredictPipelineWriteConfig> algorithmFactory() {
        return new NodeClassificationPredictPipelineAlgorithmFactory<NodeClassificationPredictPipelineWriteConfig>(this.executionContext(), this.modelCatalog);
    }

    public static final class WriteResult
    extends StandardWriteResult {
        public final long nodePropertiesWritten;

        WriteResult(long preProcessingMillis, long computeMillis, long writeMillis, long nodePropertiesWritten, Map<String, Object> configuration) {
            super(preProcessingMillis, computeMillis, 0L, writeMillis, configuration);
            this.nodePropertiesWritten = nodePropertiesWritten;
        }

        static class Builder
        extends AbstractResultBuilder<WriteResult> {
            Builder() {
            }

            public WriteResult build() {
                return new WriteResult(this.preProcessingMillis, this.computeMillis, this.writeMillis, this.nodePropertiesWritten, this.config.toMap());
            }
        }
    }
}

