/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels.pipeline;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.ml.nodemodels.pipeline.NodeClassificationPipelineCompanion;
import org.neo4j.gds.ml.nodemodels.pipeline.PipelineInfoResult;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodeClassificationPipeline;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodeClassificationSplitConfig;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeClassificationPipelineConfigureSplitProc
extends BaseProc {
    @Context
    public ModelCatalog modelCatalog;

    @Procedure(name="gds.alpha.ml.pipeline.nodeClassification.configureSplit", mode=Mode.READ)
    @Description(value="Configures the split of the node classification pipeline.")
    public Stream<PipelineInfoResult> configureSplit(@Name(value="pipelineName") String pipelineName, @Name(value="configuration") Map<String, Object> configMap) {
        NodeClassificationPipeline pipeline = NodeClassificationPipelineCompanion.getNCPipeline(this.modelCatalog, pipelineName, this.username());
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configMap);
        NodeClassificationSplitConfig config = NodeClassificationSplitConfig.of((CypherMapWrapper)cypherConfig);
        cypherConfig.requireOnlyKeysFrom(config.configKeys());
        pipeline.setSplitConfig(config);
        return Stream.of(new PipelineInfoResult(pipelineName, pipeline));
    }
}

