/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels.pipeline;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeLogisticRegressionTrainCoreConfigImpl;
import org.neo4j.gds.ml.nodemodels.pipeline.NodeClassificationPipelineCompanion;
import org.neo4j.gds.ml.nodemodels.pipeline.PipelineInfoResult;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodeClassificationPipeline;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeClassificationPipelineConfigureParamsProc
extends BaseProc {
    @Context
    public ModelCatalog modelCatalog;

    @Procedure(name="gds.alpha.ml.pipeline.nodeClassification.configureParams", mode=Mode.READ)
    @Description(value="Configures the parameters of the node classification train pipeline.")
    public Stream<PipelineInfoResult> configureParams(@Name(value="pipelineName") String pipelineName, @Name(value="parameterSpace") List<Map<String, Object>> parameterSpace) {
        NodeClassificationPipeline pipeline = NodeClassificationPipelineCompanion.getNCPipeline(this.modelCatalog, pipelineName, this.username());
        List trainConfigs = parameterSpace.stream().map(CypherMapWrapper::create).map(rawConfig -> {
            NodeLogisticRegressionTrainCoreConfigImpl config = new NodeLogisticRegressionTrainCoreConfigImpl(rawConfig);
            this.validateConfig((CypherMapWrapper)rawConfig, config.configKeys());
            return config;
        }).collect(Collectors.toList());
        pipeline.setTrainingParameterSpace(trainConfigs);
        return Stream.of(new PipelineInfoResult(pipelineName, pipeline));
    }
}

