/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels.pipeline;

import java.util.List;
import java.util.Map;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.ml.nodemodels.pipeline.NodeClassificationPipelineCompanion;
import org.neo4j.gds.ml.nodemodels.pipeline.PipelineInfoResult;
import org.neo4j.gds.ml.pipeline.FeatureStep;
import org.neo4j.gds.ml.pipeline.NodePropertyStepFactory;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodeClassificationFeatureStep;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodeClassificationPipeline;

public final class NodeClassificationPipelineAddSteps {
    public static PipelineInfoResult addNodeProperty(ModelCatalog modelCatalog, String username, BaseProc caller, String pipelineName, String taskName, Map<String, Object> procedureConfig) {
        NodeClassificationPipeline pipeline = NodeClassificationPipelineCompanion.getNCPipeline(modelCatalog, pipelineName, username);
        pipeline.addNodePropertyStep(NodePropertyStepFactory.createNodePropertyStep((String)caller.executionContext().username(), (String)taskName, procedureConfig));
        return new PipelineInfoResult(pipelineName, pipeline);
    }

    public static PipelineInfoResult selectFeatures(ModelCatalog modelCatalog, String username, String pipelineName, Object nodeProperties) {
        NodeClassificationPipeline pipeline = NodeClassificationPipelineCompanion.getNCPipeline(modelCatalog, pipelineName, username);
        if (nodeProperties instanceof String) {
            pipeline.addFeatureStep((FeatureStep)NodeClassificationFeatureStep.of((String)((String)nodeProperties)));
        } else if (nodeProperties instanceof List) {
            List propertiesList = (List)nodeProperties;
            for (Object o : propertiesList) {
                if (!(o instanceof String)) {
                    throw new IllegalArgumentException("The list `nodeProperties` is required to contain only strings.");
                }
                pipeline.addFeatureStep((FeatureStep)NodeClassificationFeatureStep.of((String)((String)o)));
            }
        } else {
            throw new IllegalArgumentException("The value of `nodeProperties` is required to be a list of strings.");
        }
        return new PipelineInfoResult(pipelineName, pipeline);
    }
}

