/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels.pipeline;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.ml.nodemodels.NodeClassificationTrain;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeLogisticRegressionData;
import org.neo4j.gds.ml.nodemodels.pipeline.NodeClassificationPipelineTrainResult;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodeClassificationPipelineModelInfo;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodeClassificationPipelineTrainConfig;

@ParametersAreNonnullByDefault
@Generated(from="NodeClassificationPipelineTrainResult", generator="Immutables")
@Immutable
public final class ImmutableNodeClassificationPipelineTrainResult
implements NodeClassificationPipelineTrainResult {
    private final Model<NodeLogisticRegressionData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> model;
    private final NodeClassificationTrain.ModelSelectResult modelSelectionStatistics;

    private ImmutableNodeClassificationPipelineTrainResult(Model<NodeLogisticRegressionData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> model, NodeClassificationTrain.ModelSelectResult modelSelectionStatistics) {
        this.model = Objects.requireNonNull(model, "model");
        this.modelSelectionStatistics = Objects.requireNonNull(modelSelectionStatistics, "modelSelectionStatistics");
    }

    private ImmutableNodeClassificationPipelineTrainResult(ImmutableNodeClassificationPipelineTrainResult original, Model<NodeLogisticRegressionData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> model, NodeClassificationTrain.ModelSelectResult modelSelectionStatistics) {
        this.model = model;
        this.modelSelectionStatistics = modelSelectionStatistics;
    }

    @Override
    public Model<NodeLogisticRegressionData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> model() {
        return this.model;
    }

    @Override
    public NodeClassificationTrain.ModelSelectResult modelSelectionStatistics() {
        return this.modelSelectionStatistics;
    }

    public final ImmutableNodeClassificationPipelineTrainResult withModel(Model<NodeLogisticRegressionData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> value) {
        if (this.model == value) {
            return this;
        }
        Model<NodeLogisticRegressionData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> newValue = Objects.requireNonNull(value, "model");
        return new ImmutableNodeClassificationPipelineTrainResult(this, newValue, this.modelSelectionStatistics);
    }

    public final ImmutableNodeClassificationPipelineTrainResult withModelSelectionStatistics(NodeClassificationTrain.ModelSelectResult value) {
        if (this.modelSelectionStatistics == value) {
            return this;
        }
        NodeClassificationTrain.ModelSelectResult newValue = Objects.requireNonNull(value, "modelSelectionStatistics");
        return new ImmutableNodeClassificationPipelineTrainResult(this, this.model, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeClassificationPipelineTrainResult && this.equalTo((ImmutableNodeClassificationPipelineTrainResult)another);
    }

    private boolean equalTo(ImmutableNodeClassificationPipelineTrainResult another) {
        return this.model.equals(another.model) && this.modelSelectionStatistics.equals(another.modelSelectionStatistics);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.model.hashCode();
        h += (h << 5) + this.modelSelectionStatistics.hashCode();
        return h;
    }

    public String toString() {
        return "NodeClassificationPipelineTrainResult{model=" + this.model + ", modelSelectionStatistics=" + this.modelSelectionStatistics + "}";
    }

    public static NodeClassificationPipelineTrainResult of(Model<NodeLogisticRegressionData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> model, NodeClassificationTrain.ModelSelectResult modelSelectionStatistics) {
        return new ImmutableNodeClassificationPipelineTrainResult(model, modelSelectionStatistics);
    }

    public static NodeClassificationPipelineTrainResult copyOf(NodeClassificationPipelineTrainResult instance) {
        if (instance instanceof ImmutableNodeClassificationPipelineTrainResult) {
            return (ImmutableNodeClassificationPipelineTrainResult)instance;
        }
        return ImmutableNodeClassificationPipelineTrainResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NodeClassificationPipelineTrainResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MODEL = 1L;
        private static final long INIT_BIT_MODEL_SELECTION_STATISTICS = 2L;
        private long initBits = 3L;
        @Nullable
        private Model<NodeLogisticRegressionData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> model;
        @Nullable
        private NodeClassificationTrain.ModelSelectResult modelSelectionStatistics;

        private Builder() {
        }

        public final Builder from(NodeClassificationPipelineTrainResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.model(instance.model());
            this.modelSelectionStatistics(instance.modelSelectionStatistics());
            return this;
        }

        public final Builder model(Model<NodeLogisticRegressionData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> model) {
            this.model = Objects.requireNonNull(model, "model");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder modelSelectionStatistics(NodeClassificationTrain.ModelSelectResult modelSelectionStatistics) {
            this.modelSelectionStatistics = Objects.requireNonNull(modelSelectionStatistics, "modelSelectionStatistics");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.model = null;
            this.modelSelectionStatistics = null;
            return this;
        }

        public NodeClassificationPipelineTrainResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeClassificationPipelineTrainResult(null, this.model, this.modelSelectionStatistics);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("model");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("modelSelectionStatistics");
            }
            return "Cannot build NodeClassificationPipelineTrainResult, some of required attributes are not set " + attributes;
        }
    }
}

