/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.TrainProc;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.AfterLoadValidation;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.ml.MLTrainResult;
import org.neo4j.gds.ml.nodemodels.NodeClassificationModelInfo;
import org.neo4j.gds.ml.nodemodels.NodeClassificationTrain;
import org.neo4j.gds.ml.nodemodels.NodeClassificationTrainAlgorithmFactory;
import org.neo4j.gds.ml.nodemodels.NodeClassificationTrainConfig;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeLogisticRegressionData;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.ml.nodeClassification.train", description="Trains a node classification model", executionMode=ExecutionMode.TRAIN)
public class NodeClassificationTrainProc
extends TrainProc<NodeClassificationTrain, Model<NodeLogisticRegressionData, NodeClassificationTrainConfig, NodeClassificationModelInfo>, NodeClassificationTrainConfig, MLTrainResult> {
    @Procedure(name="gds.alpha.ml.nodeClassification.train", mode=Mode.READ)
    @Description(value="Trains a node classification model")
    public Stream<MLTrainResult> train(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.trainAndStoreModelWithResult(this.compute(graphName, configuration));
    }

    @Procedure(name="gds.alpha.ml.nodeClassification.train.estimate", mode=Mode.READ)
    @Description(value="Trains a node classification model")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected String modelType() {
        return "nodeLogisticRegression";
    }

    protected MLTrainResult constructProcResult(ComputationResult<NodeClassificationTrain, Model<NodeLogisticRegressionData, NodeClassificationTrainConfig, NodeClassificationModelInfo>, NodeClassificationTrainConfig> computationResult) {
        return new MLTrainResult((Model)computationResult.result(), computationResult.computeMillis());
    }

    protected Model<?, ?, ?> extractModel(Model<NodeLogisticRegressionData, NodeClassificationTrainConfig, NodeClassificationModelInfo> algoResult) {
        return algoResult;
    }

    public ValidationConfiguration<NodeClassificationTrainConfig> validationConfig() {
        return new ValidationConfiguration<NodeClassificationTrainConfig>(){

            public List<AfterLoadValidation<NodeClassificationTrainConfig>> afterLoadValidations() {
                return List.of((graphStore, graphProjectConfig, config) -> {
                    Collection filterLabels = config.nodeLabelIdentifiers(graphStore);
                    if (!graphStore.hasNodeProperty(filterLabels, config.targetProperty())) {
                        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"`%s`: `%s` not found in graph with node properties: %s", (Object[])new Object[]{"targetProperty", config.targetProperty(), StringJoining.join((Collection)graphStore.nodePropertyKeys(filterLabels))}));
                    }
                });
            }
        };
    }

    protected NodeClassificationTrainConfig newConfig(String username, CypherMapWrapper config) {
        return NodeClassificationTrainConfig.of((String)username, (CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<NodeClassificationTrain, NodeClassificationTrainConfig> algorithmFactory() {
        return new NodeClassificationTrainAlgorithmFactory();
    }
}

