/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.ml.nodemodels.NodeClassificationCompanion;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredict;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredictAlgorithmFactory;
import org.neo4j.gds.ml.nodemodels.NodeClassificationStreamConfig;
import org.neo4j.gds.ml.nodemodels.NodeClassificationStreamResult;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeClassificationResult;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.ml.nodeClassification.predict.stream", description="Predicts classes for all nodes based on a previously trained model", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY)
public class NodeClassificationPredictStreamProc
extends StreamProc<NodeClassificationPredict, NodeClassificationResult, NodeClassificationStreamResult, NodeClassificationStreamConfig> {
    @Context
    public ModelCatalog modelCatalog;

    @Procedure(name="gds.alpha.ml.nodeClassification.predict.stream", mode=Mode.READ)
    @Description(value="Predicts classes for all nodes based on a previously trained model")
    public Stream<NodeClassificationStreamResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult result = this.compute(graphName, configuration);
        return this.stream((ComputationResult<NodeClassificationPredict, NodeClassificationResult, NodeClassificationStreamConfig>)result);
    }

    @Procedure(name="gds.alpha.ml.nodeClassification.predict.stream.estimate", mode=Mode.READ)
    @Description(value="Predicts classes for all nodes based on a previously trained model")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected Stream<NodeClassificationStreamResult> stream(ComputationResult<NodeClassificationPredict, NodeClassificationResult, NodeClassificationStreamConfig> computationResult) {
        return (Stream)this.runWithExceptionLogging("Graph streaming failed", () -> {
            Graph graph = computationResult.graph();
            NodeClassificationResult result = (NodeClassificationResult)computationResult.result();
            HugeLongArray predictedClasses = result.predictedClasses();
            Optional predictedProbabilities = result.predictedProbabilities();
            return LongStream.range(0L, graph.nodeCount()).boxed().map(nodeId -> new NodeClassificationStreamResult(graph.toOriginalNodeId(nodeId.longValue()), predictedClasses.get(nodeId.longValue()), this.nodePropertiesAsList(predictedProbabilities, (long)nodeId)));
        });
    }

    private List<Double> nodePropertiesAsList(Optional<HugeObjectArray<double[]>> predictedProbabilities, long nodeId) {
        return predictedProbabilities.map(p -> {
            double[] values = (double[])p.get(nodeId);
            return Arrays.stream(values).boxed().collect(Collectors.toList());
        }).orElse(null);
    }

    public ValidationConfiguration<NodeClassificationStreamConfig> validationConfig() {
        return NodeClassificationCompanion.getValidationConfig(this.modelCatalog);
    }

    protected NodeClassificationStreamConfig newConfig(String username, CypherMapWrapper config) {
        return NodeClassificationStreamConfig.of((String)username, (CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<NodeClassificationPredict, NodeClassificationStreamConfig> algorithmFactory() {
        return new NodeClassificationPredictAlgorithmFactory(this.modelCatalog);
    }

    protected NodeProperties nodeProperties(ComputationResult<NodeClassificationPredict, NodeClassificationResult, NodeClassificationStreamConfig> computationResult) {
        return super.nodeProperties(computationResult);
    }

    protected NodeClassificationStreamResult streamResult(long originalNodeId, long internalNodeId, NodeProperties nodeProperties) {
        throw new UnsupportedOperationException("NodeClassification handles result building individually.");
    }
}

