/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.MutatePropertyProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.DoubleArrayNodeProperties;
import org.neo4j.gds.api.nodeproperties.LongNodeProperties;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.write.NodeProperty;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.ml.nodemodels.NodeClassificationCompanion;
import org.neo4j.gds.ml.nodemodels.NodeClassificationMutateConfig;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredict;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredictAlgorithmFactory;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeClassificationResult;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.results.StandardMutateResult;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.ml.nodeClassification.predict.mutate", description="Predicts classes for all nodes based on a previously trained model", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY)
public class NodeClassificationPredictMutateProc
extends MutatePropertyProc<NodeClassificationPredict, NodeClassificationResult, MutateResult, NodeClassificationMutateConfig> {
    @Context
    public ModelCatalog modelCatalog;

    @Procedure(name="gds.alpha.ml.nodeClassification.predict.mutate", mode=Mode.READ)
    @Description(value="Predicts classes for all nodes based on a previously trained model")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult result = this.compute(graphName, configuration);
        return this.mutate(result);
    }

    @Procedure(name="gds.alpha.ml.nodeClassification.predict.mutate.estimate", mode=Mode.READ)
    @Description(value="Predicts classes for all nodes based on a previously trained model")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(ComputationResult<NodeClassificationPredict, NodeClassificationResult, NodeClassificationMutateConfig> computeResult, ExecutionContext executionContext) {
        return new MutateResult.Builder();
    }

    public ValidationConfiguration<NodeClassificationMutateConfig> validationConfig() {
        return NodeClassificationCompanion.getValidationConfig(this.modelCatalog);
    }

    protected NodeClassificationMutateConfig newConfig(String username, CypherMapWrapper config) {
        return NodeClassificationMutateConfig.of((String)username, (CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<NodeClassificationPredict, NodeClassificationMutateConfig> algorithmFactory() {
        return new NodeClassificationPredictAlgorithmFactory(this.modelCatalog);
    }

    protected List<NodeProperty> nodePropertyList(ComputationResult<NodeClassificationPredict, NodeClassificationResult, NodeClassificationMutateConfig> computationResult) {
        NodeClassificationMutateConfig config = (NodeClassificationMutateConfig)computationResult.config();
        String mutateProperty = config.mutateProperty();
        NodeClassificationResult result = (NodeClassificationResult)computationResult.result();
        LongNodeProperties classProperties = result.predictedClasses().asNodeProperties();
        ArrayList<NodeProperty> nodeProperties = new ArrayList<NodeProperty>();
        nodeProperties.add(NodeProperty.of((String)mutateProperty, (NodeProperties)classProperties));
        result.predictedProbabilities().ifPresent(probabilityProperties -> {
            DoubleArrayNodeProperties properties = new DoubleArrayNodeProperties((ComputationResult)computationResult, (HugeObjectArray)probabilityProperties){
                final /* synthetic */ ComputationResult val$computationResult;
                final /* synthetic */ HugeObjectArray val$probabilityProperties;
                {
                    this.val$computationResult = computationResult;
                    this.val$probabilityProperties = hugeObjectArray;
                }

                public long size() {
                    return this.val$computationResult.graph().nodeCount();
                }

                public double[] doubleArrayValue(long nodeId) {
                    return (double[])this.val$probabilityProperties.get(nodeId);
                }
            };
            nodeProperties.add(NodeProperty.of((String)((String)config.predictedProbabilityProperty().orElseThrow()), (NodeProperties)properties));
        });
        return nodeProperties;
    }

    public static final class MutateResult
    extends StandardMutateResult {
        public final long nodePropertiesWritten;

        MutateResult(long preProcessingMillis, long computeMillis, long mutateMillis, long nodePropertiesWritten, Map<String, Object> configuration) {
            super(preProcessingMillis, computeMillis, 0L, mutateMillis, configuration);
            this.nodePropertiesWritten = nodePropertiesWritten;
        }

        static class Builder
        extends AbstractResultBuilder<MutateResult> {
            Builder() {
            }

            public MutateResult build() {
                return new MutateResult(this.preProcessingMillis, this.computeMillis, this.mutateMillis, this.nodePropertiesWritten, this.config.toMap());
            }
        }
    }
}

