/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels;

import java.util.List;
import java.util.Optional;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.executor.GraphStoreValidation;
import org.neo4j.gds.executor.validation.AfterLoadValidation;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.ml.nodemodels.NodeClassificationModelInfo;
import org.neo4j.gds.ml.nodemodels.NodeClassificationMutateConfig;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredictConfig;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredictWriteConfig;
import org.neo4j.gds.ml.nodemodels.NodeClassificationTrainConfig;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeLogisticRegressionData;
import org.neo4j.gds.utils.StringFormatting;

final class NodeClassificationCompanion {
    static <CONFIG extends NodeClassificationPredictConfig> ValidationConfiguration<CONFIG> getValidationConfig(final ModelCatalog modelCatalog) {
        return new ValidationConfiguration<CONFIG>(){

            public List<AfterLoadValidation<CONFIG>> afterLoadValidations() {
                return List.of((graphStore, graphProjectConfig, config) -> {
                    if (config instanceof NodeClassificationMutateConfig) {
                        NodeClassificationMutateConfig mutateConfig = (NodeClassificationMutateConfig)config;
                        NodeClassificationCompanion.validateProperties(mutateConfig.mutateProperty(), mutateConfig.predictedProbabilityProperty());
                    }
                    if (config instanceof NodeClassificationPredictWriteConfig) {
                        NodeClassificationPredictWriteConfig writeConfig = (NodeClassificationPredictWriteConfig)config;
                        NodeClassificationCompanion.validateProperties(writeConfig.writeProperty(), writeConfig.predictedProbabilityProperty());
                    }
                    NodeClassificationTrainConfig trainConfig = (NodeClassificationTrainConfig)modelCatalog.get(config.username(), config.modelName(), NodeLogisticRegressionData.class, NodeClassificationTrainConfig.class, NodeClassificationModelInfo.class).trainConfig();
                    GraphStoreValidation.validate((GraphStore)graphStore, (AlgoBaseConfig)trainConfig);
                });
            }
        };
    }

    private static void validateProperties(String property, Optional<String> maybePredictedProbabilityProperty) {
        maybePredictedProbabilityProperty.ifPresent(predictedProbabilityProperty -> {
            if (property.equals(predictedProbabilityProperty)) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Configuration parameters `%s` and `%s` must be different (both were `%s`)", (Object[])new Object[]{"mutateProperty", "predictedProbabilityProperty", predictedProbabilityProperty}));
            }
        });
    }

    private NodeClassificationCompanion() {
    }
}

