/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.train;

import java.util.List;
import org.neo4j.gds.GraphStoreAlgorithmFactory;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.exceptions.MemoryEstimationNotImplementedException;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionPipelineCompanion;
import org.neo4j.gds.ml.linkmodels.pipeline.train.LinkPredictionTrain;
import org.neo4j.gds.ml.linkmodels.pipeline.train.LinkPredictionTrainConfig;
import org.neo4j.gds.ml.linkmodels.pipeline.train.LinkPredictionTrainPipelineExecutor;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkPredictionPipeline;

public class LinkPredictionTrainPipelineAlgorithmFactory
extends GraphStoreAlgorithmFactory<LinkPredictionTrainPipelineExecutor, LinkPredictionTrainConfig> {
    private final ExecutionContext executionContext;
    private final ModelCatalog modelCatalog;

    public LinkPredictionTrainPipelineAlgorithmFactory(ExecutionContext executionContext, ModelCatalog modelCatalog) {
        this.executionContext = executionContext;
        this.modelCatalog = modelCatalog;
    }

    public LinkPredictionTrainPipelineExecutor build(GraphStore graphStore, LinkPredictionTrainConfig trainConfig, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
        LinkPredictionPipeline pipeline = LinkPredictionPipelineCompanion.getLPPipeline(this.modelCatalog, trainConfig.pipeline(), trainConfig.username());
        pipeline.validate();
        return new LinkPredictionTrainPipelineExecutor(pipeline, trainConfig, this.executionContext, graphStore, trainConfig.graphName(), progressTracker);
    }

    public String taskName() {
        return "Link Prediction Train Pipeline";
    }

    public Task progressTask(GraphStore graphStore, LinkPredictionTrainConfig config) {
        LinkPredictionPipeline pipeline = LinkPredictionPipelineCompanion.getLPPipeline(this.modelCatalog, config.pipeline(), config.username());
        return Tasks.task((String)this.taskName(), (Task)Tasks.leaf((String)"split relationships"), (Task[])new Task[]{Tasks.iterativeFixed((String)"execute node property steps", () -> List.of(Tasks.leaf((String)"step")), (int)pipeline.nodePropertySteps().size()), LinkPredictionTrain.progressTask()});
    }

    public MemoryEstimation memoryEstimation(LinkPredictionTrainConfig configuration) {
        throw new MemoryEstimationNotImplementedException();
    }
}

