/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.train;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.linkmodels.metrics.LinkMetric;
import org.neo4j.gds.ml.linkmodels.pipeline.logisticRegression.LinkLogisticRegressionTrainConfig;
import org.neo4j.gds.ml.linkmodels.pipeline.train.LinkPredictionTrain;
import org.neo4j.gds.ml.nodemodels.ModelStats;

@ParametersAreNonnullByDefault
@Generated(from="LinkPredictionTrain.ModelSelectResult", generator="Immutables")
@Immutable
public final class ImmutableModelSelectResult
implements LinkPredictionTrain.ModelSelectResult {
    private final LinkLogisticRegressionTrainConfig bestParameters;
    private final Map<LinkMetric, List<ModelStats<LinkLogisticRegressionTrainConfig>>> trainStats;
    private final Map<LinkMetric, List<ModelStats<LinkLogisticRegressionTrainConfig>>> validationStats;
    private final transient Map<String, Object> toMap;

    private ImmutableModelSelectResult(LinkLogisticRegressionTrainConfig bestParameters, Map<LinkMetric, ? extends List<ModelStats<LinkLogisticRegressionTrainConfig>>> trainStats, Map<LinkMetric, ? extends List<ModelStats<LinkLogisticRegressionTrainConfig>>> validationStats) {
        this.bestParameters = Objects.requireNonNull(bestParameters, "bestParameters");
        this.trainStats = ImmutableModelSelectResult.createUnmodifiableEnumMap(true, false, trainStats);
        this.validationStats = ImmutableModelSelectResult.createUnmodifiableEnumMap(true, false, validationStats);
        this.toMap = Objects.requireNonNull(LinkPredictionTrain.ModelSelectResult.super.toMap(), "toMap");
    }

    private ImmutableModelSelectResult(ImmutableModelSelectResult original, LinkLogisticRegressionTrainConfig bestParameters, Map<LinkMetric, List<ModelStats<LinkLogisticRegressionTrainConfig>>> trainStats, Map<LinkMetric, List<ModelStats<LinkLogisticRegressionTrainConfig>>> validationStats) {
        this.bestParameters = bestParameters;
        this.trainStats = trainStats;
        this.validationStats = validationStats;
        this.toMap = Objects.requireNonNull(LinkPredictionTrain.ModelSelectResult.super.toMap(), "toMap");
    }

    @Override
    public LinkLogisticRegressionTrainConfig bestParameters() {
        return this.bestParameters;
    }

    @Override
    public Map<LinkMetric, List<ModelStats<LinkLogisticRegressionTrainConfig>>> trainStats() {
        return this.trainStats;
    }

    @Override
    public Map<LinkMetric, List<ModelStats<LinkLogisticRegressionTrainConfig>>> validationStats() {
        return this.validationStats;
    }

    @Override
    public Map<String, Object> toMap() {
        return this.toMap;
    }

    public final ImmutableModelSelectResult withBestParameters(LinkLogisticRegressionTrainConfig value) {
        if (this.bestParameters == value) {
            return this;
        }
        LinkLogisticRegressionTrainConfig newValue = Objects.requireNonNull(value, "bestParameters");
        return new ImmutableModelSelectResult(this, newValue, this.trainStats, this.validationStats);
    }

    public final ImmutableModelSelectResult withTrainStats(Map<LinkMetric, ? extends List<ModelStats<LinkLogisticRegressionTrainConfig>>> entries) {
        if (this.trainStats == entries) {
            return this;
        }
        Map<LinkMetric, List<ModelStats<LinkLogisticRegressionTrainConfig>>> newValue = ImmutableModelSelectResult.createUnmodifiableEnumMap(true, false, entries);
        return new ImmutableModelSelectResult(this, this.bestParameters, newValue, this.validationStats);
    }

    public final ImmutableModelSelectResult withValidationStats(Map<LinkMetric, ? extends List<ModelStats<LinkLogisticRegressionTrainConfig>>> entries) {
        if (this.validationStats == entries) {
            return this;
        }
        Map<LinkMetric, List<ModelStats<LinkLogisticRegressionTrainConfig>>> newValue = ImmutableModelSelectResult.createUnmodifiableEnumMap(true, false, entries);
        return new ImmutableModelSelectResult(this, this.bestParameters, this.trainStats, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableModelSelectResult && this.equalTo((ImmutableModelSelectResult)another);
    }

    private boolean equalTo(ImmutableModelSelectResult another) {
        return this.bestParameters.equals(another.bestParameters) && this.trainStats.equals(another.trainStats) && this.validationStats.equals(another.validationStats) && this.toMap.equals(another.toMap);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.bestParameters.hashCode();
        h += (h << 5) + this.trainStats.hashCode();
        h += (h << 5) + this.validationStats.hashCode();
        h += (h << 5) + this.toMap.hashCode();
        return h;
    }

    public String toString() {
        return "ModelSelectResult{bestParameters=" + this.bestParameters + ", trainStats=" + this.trainStats + ", validationStats=" + this.validationStats + ", toMap=" + this.toMap + "}";
    }

    public static LinkPredictionTrain.ModelSelectResult of(LinkLogisticRegressionTrainConfig bestParameters, Map<LinkMetric, ? extends List<ModelStats<LinkLogisticRegressionTrainConfig>>> trainStats, Map<LinkMetric, ? extends List<ModelStats<LinkLogisticRegressionTrainConfig>>> validationStats) {
        return new ImmutableModelSelectResult(bestParameters, trainStats, validationStats);
    }

    public static LinkPredictionTrain.ModelSelectResult copyOf(LinkPredictionTrain.ModelSelectResult instance) {
        if (instance instanceof ImmutableModelSelectResult) {
            return (ImmutableModelSelectResult)instance;
        }
        return ImmutableModelSelectResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K extends Enum<K>, V> Map<K, V> createUnmodifiableEnumMap(boolean checkNulls, boolean skipNulls, Map<K, ? extends V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        EnumMap<K, ? extends V> enumMap = new EnumMap<K, V>(map);
        if (checkNulls || skipNulls) {
            Iterator<V> it = map.values().iterator();
            while (it.hasNext()) {
                V v = it.next();
                if (checkNulls) {
                    Objects.requireNonNull(v, "value");
                    continue;
                }
                if (!skipNulls || v != null) continue;
                it.remove();
            }
        }
        return Collections.unmodifiableMap(enumMap);
    }

    @Generated(from="LinkPredictionTrain.ModelSelectResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BEST_PARAMETERS = 1L;
        private long initBits = 1L;
        @Nullable
        private LinkLogisticRegressionTrainConfig bestParameters;
        private EnumMap<LinkMetric, List<ModelStats<LinkLogisticRegressionTrainConfig>>> trainStats = null;
        private EnumMap<LinkMetric, List<ModelStats<LinkLogisticRegressionTrainConfig>>> validationStats = null;

        private Builder() {
        }

        public final Builder from(LinkPredictionTrain.ModelSelectResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.bestParameters(instance.bestParameters());
            this.putAllTrainStats(instance.trainStats());
            this.putAllValidationStats(instance.validationStats());
            return this;
        }

        public final Builder bestParameters(LinkLogisticRegressionTrainConfig bestParameters) {
            this.bestParameters = Objects.requireNonNull(bestParameters, "bestParameters");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder putTrainStat(LinkMetric key, List<ModelStats<LinkLogisticRegressionTrainConfig>> value) {
            if (this.trainStats == null) {
                this.trainStats = new EnumMap(LinkMetric.class);
            }
            this.trainStats.put(Objects.requireNonNull(key, "trainStats key"), Objects.requireNonNull(value, "trainStats value"));
            return this;
        }

        public final Builder putTrainStat(Map.Entry<LinkMetric, ? extends List<ModelStats<LinkLogisticRegressionTrainConfig>>> entry) {
            if (this.trainStats == null) {
                this.trainStats = new EnumMap(LinkMetric.class);
            }
            LinkMetric k = entry.getKey();
            List<ModelStats<LinkLogisticRegressionTrainConfig>> v = entry.getValue();
            this.trainStats.put(Objects.requireNonNull(k, "trainStats key"), Objects.requireNonNull(v, "trainStats value"));
            return this;
        }

        public final Builder trainStats(Map<LinkMetric, ? extends List<ModelStats<LinkLogisticRegressionTrainConfig>>> entries) {
            this.trainStats = new EnumMap(LinkMetric.class);
            return this.putAllTrainStats(entries);
        }

        public final Builder putAllTrainStats(Map<LinkMetric, ? extends List<ModelStats<LinkLogisticRegressionTrainConfig>>> entries) {
            if (this.trainStats == null) {
                this.trainStats = new EnumMap(LinkMetric.class);
            }
            for (Map.Entry<LinkMetric, ? extends List<ModelStats<LinkLogisticRegressionTrainConfig>>> e : entries.entrySet()) {
                LinkMetric k = e.getKey();
                List<ModelStats<LinkLogisticRegressionTrainConfig>> v = e.getValue();
                this.trainStats.put(Objects.requireNonNull(k, "trainStats key"), Objects.requireNonNull(v, "trainStats value"));
            }
            return this;
        }

        public final Builder putValidationStat(LinkMetric key, List<ModelStats<LinkLogisticRegressionTrainConfig>> value) {
            if (this.validationStats == null) {
                this.validationStats = new EnumMap(LinkMetric.class);
            }
            this.validationStats.put(Objects.requireNonNull(key, "validationStats key"), Objects.requireNonNull(value, "validationStats value"));
            return this;
        }

        public final Builder putValidationStat(Map.Entry<LinkMetric, ? extends List<ModelStats<LinkLogisticRegressionTrainConfig>>> entry) {
            if (this.validationStats == null) {
                this.validationStats = new EnumMap(LinkMetric.class);
            }
            LinkMetric k = entry.getKey();
            List<ModelStats<LinkLogisticRegressionTrainConfig>> v = entry.getValue();
            this.validationStats.put(Objects.requireNonNull(k, "validationStats key"), Objects.requireNonNull(v, "validationStats value"));
            return this;
        }

        public final Builder validationStats(Map<LinkMetric, ? extends List<ModelStats<LinkLogisticRegressionTrainConfig>>> entries) {
            this.validationStats = new EnumMap(LinkMetric.class);
            return this.putAllValidationStats(entries);
        }

        public final Builder putAllValidationStats(Map<LinkMetric, ? extends List<ModelStats<LinkLogisticRegressionTrainConfig>>> entries) {
            if (this.validationStats == null) {
                this.validationStats = new EnumMap(LinkMetric.class);
            }
            for (Map.Entry<LinkMetric, ? extends List<ModelStats<LinkLogisticRegressionTrainConfig>>> e : entries.entrySet()) {
                LinkMetric k = e.getKey();
                List<ModelStats<LinkLogisticRegressionTrainConfig>> v = e.getValue();
                this.validationStats.put(Objects.requireNonNull(k, "validationStats key"), Objects.requireNonNull(v, "validationStats value"));
            }
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.bestParameters = null;
            if (this.trainStats != null) {
                this.trainStats.clear();
            }
            if (this.validationStats != null) {
                this.validationStats.clear();
            }
            return this;
        }

        public LinkPredictionTrain.ModelSelectResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableModelSelectResult(null, this.bestParameters, this.trainStats == null ? Collections.emptyMap() : ImmutableModelSelectResult.createUnmodifiableEnumMap(false, false, this.trainStats), this.validationStats == null ? Collections.emptyMap() : ImmutableModelSelectResult.createUnmodifiableEnumMap(false, false, this.validationStats));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("bestParameters");
            }
            return "Cannot build ModelSelectResult, some of required attributes are not set " + attributes;
        }
    }
}

