/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.train;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.RandomSeedConfig;
import org.neo4j.gds.ml.linkmodels.metrics.LinkMetric;
import org.neo4j.gds.ml.linkmodels.pipeline.train.LinkPredictionTrainConfig;
import org.neo4j.gds.model.ModelConfig;

@ParametersAreNonnullByDefault
@Generated(from="LinkPredictionTrainConfig", generator="Immutables")
@Immutable
public final class ImmutableLinkPredictionTrainConfig
implements LinkPredictionTrainConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final String modelName;
    private final String username;
    @javax.annotation.Nullable
    private final Long randomSeed;
    private final String graphName;
    private final double negativeClassWeight;
    private final String pipeline;
    private final List<LinkMetric> metrics;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableLinkPredictionTrainConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String modelName, String username, Optional<Long> randomSeed, String graphName, double negativeClassWeight, String pipeline, Iterable<? extends LinkMetric> metrics) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableLinkPredictionTrainConfig.createUnmodifiableList(false, ImmutableLinkPredictionTrainConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableLinkPredictionTrainConfig.createUnmodifiableList(false, ImmutableLinkPredictionTrainConfig.createSafeList(nodeLabels, true, false)));
        this.modelName = Objects.requireNonNull(modelName, "modelName");
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.randomSeed = randomSeed.orElse(null);
        this.graphName = Objects.requireNonNull(graphName, "graphName");
        this.initShim.negativeClassWeight(negativeClassWeight);
        this.pipeline = Objects.requireNonNull(pipeline, "pipeline");
        this.initShim.metrics(ImmutableLinkPredictionTrainConfig.createUnmodifiableList(false, ImmutableLinkPredictionTrainConfig.createSafeList(metrics, true, false)));
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.username = this.initShim.username();
        this.negativeClassWeight = this.initShim.negativeClassWeight();
        this.metrics = this.initShim.metrics();
        this.initShim = null;
    }

    private ImmutableLinkPredictionTrainConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String modelName, String username, @javax.annotation.Nullable Long randomSeed, String graphName, double negativeClassWeight, String pipeline, Iterable<? extends LinkMetric> metrics) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableLinkPredictionTrainConfig.createUnmodifiableList(false, ImmutableLinkPredictionTrainConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableLinkPredictionTrainConfig.createUnmodifiableList(false, ImmutableLinkPredictionTrainConfig.createSafeList(nodeLabels, true, false)));
        this.modelName = Objects.requireNonNull(modelName, "modelName");
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.randomSeed = randomSeed;
        this.graphName = Objects.requireNonNull(graphName, "graphName");
        this.initShim.negativeClassWeight(negativeClassWeight);
        this.pipeline = Objects.requireNonNull(pipeline, "pipeline");
        this.initShim.metrics(ImmutableLinkPredictionTrainConfig.createUnmodifiableList(false, ImmutableLinkPredictionTrainConfig.createSafeList(metrics, true, false)));
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.username = this.initShim.username();
        this.negativeClassWeight = this.initShim.negativeClassWeight();
        this.metrics = this.initShim.metrics();
        this.initShim = null;
    }

    private ImmutableLinkPredictionTrainConfig(Builder builder) {
        this.modelName = builder.modelName;
        this.randomSeed = builder.randomSeed;
        this.graphName = builder.graphName;
        this.pipeline = builder.pipeline;
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableLinkPredictionTrainConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableLinkPredictionTrainConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.username != null) {
            this.initShim.username(builder.username);
        }
        if (builder.negativeClassWeightIsSet()) {
            this.initShim.negativeClassWeight(builder.negativeClassWeight);
        }
        if (builder.metricsIsSet()) {
            this.initShim.metrics(builder.metrics == null ? Collections.emptyList() : ImmutableLinkPredictionTrainConfig.createUnmodifiableList(true, builder.metrics));
        }
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.username = this.initShim.username();
        this.negativeClassWeight = this.initShim.negativeClassWeight();
        this.metrics = this.initShim.metrics();
        this.initShim = null;
    }

    private ImmutableLinkPredictionTrainConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, String modelName, String username, @javax.annotation.Nullable Long randomSeed, String graphName, double negativeClassWeight, String pipeline, List<LinkMetric> metrics) {
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.modelName = modelName;
        this.initShim.username(username);
        this.randomSeed = randomSeed;
        this.graphName = graphName;
        this.initShim.negativeClassWeight(negativeClassWeight);
        this.pipeline = pipeline;
        this.initShim.metrics(metrics);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.username = this.initShim.username();
        this.negativeClassWeight = this.initShim.negativeClassWeight();
        this.metrics = this.initShim.metrics();
        this.initShim = null;
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return LinkPredictionTrainConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return LinkPredictionTrainConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return LinkPredictionTrainConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return LinkPredictionTrainConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return LinkPredictionTrainConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return LinkPredictionTrainConfig.super.minBatchSize();
    }

    private List<String> relationshipTypesInitialize() {
        return LinkPredictionTrainConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return LinkPredictionTrainConfig.super.nodeLabels();
    }

    private String usernameInitialize() {
        return LinkPredictionTrainConfig.super.username();
    }

    private double negativeClassWeightInitialize() {
        return LinkPredictionTrainConfig.super.negativeClassWeight();
    }

    private List<LinkMetric> metricsInitialize() {
        return LinkPredictionTrainConfig.super.metrics();
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public String modelName() {
        return this.modelName;
    }

    public String username() {
        InitShim shim = this.initShim;
        return shim != null ? shim.username() : this.username;
    }

    public Optional<Long> randomSeed() {
        return Optional.ofNullable(this.randomSeed);
    }

    @Override
    public String graphName() {
        return this.graphName;
    }

    @Override
    public double negativeClassWeight() {
        InitShim shim = this.initShim;
        return shim != null ? shim.negativeClassWeight() : this.negativeClassWeight;
    }

    @Override
    public String pipeline() {
        return this.pipeline;
    }

    @Override
    public List<LinkMetric> metrics() {
        InitShim shim = this.initShim;
        return shim != null ? shim.metrics() : this.metrics;
    }

    public final ImmutableLinkPredictionTrainConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableLinkPredictionTrainConfig.validate(new ImmutableLinkPredictionTrainConfig(value, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.randomSeed, this.graphName, this.negativeClassWeight, this.pipeline, this.metrics));
    }

    public final ImmutableLinkPredictionTrainConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableLinkPredictionTrainConfig.validate(new ImmutableLinkPredictionTrainConfig(this.usernameOverride, value, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.randomSeed, this.graphName, this.negativeClassWeight, this.pipeline, this.metrics));
    }

    public final ImmutableLinkPredictionTrainConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableLinkPredictionTrainConfig.validate(new ImmutableLinkPredictionTrainConfig(this.usernameOverride, this.sudo, newValue, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.randomSeed, this.graphName, this.negativeClassWeight, this.pipeline, this.metrics));
    }

    public final ImmutableLinkPredictionTrainConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableLinkPredictionTrainConfig.validate(new ImmutableLinkPredictionTrainConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.randomSeed, this.graphName, this.negativeClassWeight, this.pipeline, this.metrics));
    }

    public final ImmutableLinkPredictionTrainConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableLinkPredictionTrainConfig.validate(new ImmutableLinkPredictionTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.randomSeed, this.graphName, this.negativeClassWeight, this.pipeline, this.metrics));
    }

    public final ImmutableLinkPredictionTrainConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableLinkPredictionTrainConfig.createUnmodifiableList(false, ImmutableLinkPredictionTrainConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableLinkPredictionTrainConfig.validate(new ImmutableLinkPredictionTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.modelName, this.username, this.randomSeed, this.graphName, this.negativeClassWeight, this.pipeline, this.metrics));
    }

    public final ImmutableLinkPredictionTrainConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableLinkPredictionTrainConfig.createUnmodifiableList(false, ImmutableLinkPredictionTrainConfig.createSafeList(elements, true, false));
        return ImmutableLinkPredictionTrainConfig.validate(new ImmutableLinkPredictionTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.modelName, this.username, this.randomSeed, this.graphName, this.negativeClassWeight, this.pipeline, this.metrics));
    }

    public final ImmutableLinkPredictionTrainConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableLinkPredictionTrainConfig.createUnmodifiableList(false, ImmutableLinkPredictionTrainConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableLinkPredictionTrainConfig.validate(new ImmutableLinkPredictionTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.modelName, this.username, this.randomSeed, this.graphName, this.negativeClassWeight, this.pipeline, this.metrics));
    }

    public final ImmutableLinkPredictionTrainConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableLinkPredictionTrainConfig.createUnmodifiableList(false, ImmutableLinkPredictionTrainConfig.createSafeList(elements, true, false));
        return ImmutableLinkPredictionTrainConfig.validate(new ImmutableLinkPredictionTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.modelName, this.username, this.randomSeed, this.graphName, this.negativeClassWeight, this.pipeline, this.metrics));
    }

    public final ImmutableLinkPredictionTrainConfig withModelName(String value) {
        String newValue = Objects.requireNonNull(value, "modelName");
        if (this.modelName.equals(newValue)) {
            return this;
        }
        return ImmutableLinkPredictionTrainConfig.validate(new ImmutableLinkPredictionTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, newValue, this.username, this.randomSeed, this.graphName, this.negativeClassWeight, this.pipeline, this.metrics));
    }

    public final ImmutableLinkPredictionTrainConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return ImmutableLinkPredictionTrainConfig.validate(new ImmutableLinkPredictionTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, newValue, this.randomSeed, this.graphName, this.negativeClassWeight, this.pipeline, this.metrics));
    }

    public final ImmutableLinkPredictionTrainConfig withRandomSeed(@javax.annotation.Nullable Long value) {
        Long newValue = value;
        if (Objects.equals(this.randomSeed, newValue)) {
            return this;
        }
        return ImmutableLinkPredictionTrainConfig.validate(new ImmutableLinkPredictionTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, newValue, this.graphName, this.negativeClassWeight, this.pipeline, this.metrics));
    }

    public final ImmutableLinkPredictionTrainConfig withRandomSeed(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.randomSeed, value)) {
            return this;
        }
        return ImmutableLinkPredictionTrainConfig.validate(new ImmutableLinkPredictionTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, value, this.graphName, this.negativeClassWeight, this.pipeline, this.metrics));
    }

    public final ImmutableLinkPredictionTrainConfig withGraphName(String value) {
        String newValue = Objects.requireNonNull(value, "graphName");
        if (this.graphName.equals(newValue)) {
            return this;
        }
        return ImmutableLinkPredictionTrainConfig.validate(new ImmutableLinkPredictionTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.randomSeed, newValue, this.negativeClassWeight, this.pipeline, this.metrics));
    }

    public final ImmutableLinkPredictionTrainConfig withNegativeClassWeight(double value) {
        if (Double.doubleToLongBits(this.negativeClassWeight) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableLinkPredictionTrainConfig.validate(new ImmutableLinkPredictionTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.randomSeed, this.graphName, value, this.pipeline, this.metrics));
    }

    public final ImmutableLinkPredictionTrainConfig withPipeline(String value) {
        String newValue = Objects.requireNonNull(value, "pipeline");
        if (this.pipeline.equals(newValue)) {
            return this;
        }
        return ImmutableLinkPredictionTrainConfig.validate(new ImmutableLinkPredictionTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.randomSeed, this.graphName, this.negativeClassWeight, newValue, this.metrics));
    }

    public final ImmutableLinkPredictionTrainConfig withMetrics(LinkMetric ... elements) {
        List<LinkMetric> newValue = ImmutableLinkPredictionTrainConfig.createUnmodifiableList(false, ImmutableLinkPredictionTrainConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableLinkPredictionTrainConfig.validate(new ImmutableLinkPredictionTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.randomSeed, this.graphName, this.negativeClassWeight, this.pipeline, newValue));
    }

    public final ImmutableLinkPredictionTrainConfig withMetrics(Iterable<? extends LinkMetric> elements) {
        if (this.metrics == elements) {
            return this;
        }
        List<LinkMetric> newValue = ImmutableLinkPredictionTrainConfig.createUnmodifiableList(false, ImmutableLinkPredictionTrainConfig.createSafeList(elements, true, false));
        return ImmutableLinkPredictionTrainConfig.validate(new ImmutableLinkPredictionTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.randomSeed, this.graphName, this.negativeClassWeight, this.pipeline, newValue));
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLinkPredictionTrainConfig && this.equalTo((ImmutableLinkPredictionTrainConfig)another);
    }

    private boolean equalTo(ImmutableLinkPredictionTrainConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && this.modelName.equals(another.modelName) && this.username.equals(another.username) && Objects.equals(this.randomSeed, another.randomSeed) && this.graphName.equals(another.graphName) && Double.doubleToLongBits(this.negativeClassWeight) == Double.doubleToLongBits(another.negativeClassWeight) && this.pipeline.equals(another.pipeline) && this.metrics.equals(another.metrics);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + this.modelName.hashCode();
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + Objects.hashCode(this.randomSeed);
        h += (h << 5) + this.graphName.hashCode();
        h += (h << 5) + Double.hashCode(this.negativeClassWeight);
        h += (h << 5) + this.pipeline.hashCode();
        h += (h << 5) + this.metrics.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("LinkPredictionTrainConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 26) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        builder.append(", ");
        builder.append("modelName=").append(this.modelName);
        builder.append(", ");
        builder.append("username=").append(this.username);
        if (this.randomSeed != null) {
            builder.append(", ");
            builder.append("randomSeed=").append(this.randomSeed);
        }
        builder.append(", ");
        builder.append("graphName=").append(this.graphName);
        builder.append(", ");
        builder.append("negativeClassWeight=").append(this.negativeClassWeight);
        builder.append(", ");
        builder.append("pipeline=").append(this.pipeline);
        builder.append(", ");
        builder.append("metrics=").append(this.metrics);
        return builder.append("}").toString();
    }

    public static LinkPredictionTrainConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, String modelName, String username, Optional<Long> randomSeed, String graphName, double negativeClassWeight, String pipeline, List<LinkMetric> metrics) {
        return ImmutableLinkPredictionTrainConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, modelName, username, randomSeed, graphName, negativeClassWeight, pipeline, metrics);
    }

    public static LinkPredictionTrainConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String modelName, String username, Optional<Long> randomSeed, String graphName, double negativeClassWeight, String pipeline, Iterable<? extends LinkMetric> metrics) {
        return ImmutableLinkPredictionTrainConfig.validate(new ImmutableLinkPredictionTrainConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, modelName, username, randomSeed, graphName, negativeClassWeight, pipeline, metrics));
    }

    public static LinkPredictionTrainConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String modelName, String username, @javax.annotation.Nullable Long randomSeed, String graphName, double negativeClassWeight, String pipeline, Iterable<? extends LinkMetric> metrics) {
        return ImmutableLinkPredictionTrainConfig.validate(new ImmutableLinkPredictionTrainConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, modelName, username, randomSeed, graphName, negativeClassWeight, pipeline, metrics));
    }

    private static ImmutableLinkPredictionTrainConfig validate(ImmutableLinkPredictionTrainConfig instance) {
        instance.validateConcurrency();
        return instance;
    }

    public static LinkPredictionTrainConfig copyOf(LinkPredictionTrainConfig instance) {
        if (instance instanceof ImmutableLinkPredictionTrainConfig) {
            return (ImmutableLinkPredictionTrainConfig)instance;
        }
        return ImmutableLinkPredictionTrainConfig.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return ImmutableLinkPredictionTrainConfig.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="LinkPredictionTrainConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MODEL_NAME = 1L;
        private static final long INIT_BIT_GRAPH_NAME = 2L;
        private static final long INIT_BIT_PIPELINE = 4L;
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_NEGATIVE_CLASS_WEIGHT = 64L;
        private static final long OPT_BIT_METRICS = 128L;
        private long initBits = 7L;
        private long optBits;
        @javax.annotation.Nullable
        private String usernameOverride;
        private boolean sudo;
        @javax.annotation.Nullable
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        @javax.annotation.Nullable
        private String modelName;
        @javax.annotation.Nullable
        private String username;
        @javax.annotation.Nullable
        private Long randomSeed;
        @javax.annotation.Nullable
        private String graphName;
        private double negativeClassWeight;
        @javax.annotation.Nullable
        private String pipeline;
        private List<LinkMetric> metrics = null;

        private Builder() {
        }

        public final Builder from(ModelConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RandomSeedConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(LinkPredictionTrainConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional randomSeedOptional;
            ModelConfig instance;
            if (object instanceof ModelConfig) {
                instance = (ModelConfig)object;
                this.modelName(instance.modelName());
                this.username(instance.username());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof RandomSeedConfig && (randomSeedOptional = (instance = (RandomSeedConfig)object).randomSeed()).isPresent()) {
                this.randomSeed(randomSeedOptional);
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof LinkPredictionTrainConfig) {
                instance = (LinkPredictionTrainConfig)object;
                this.pipeline(instance.pipeline());
                this.graphName(instance.graphName());
                this.addAllMetrics(instance.metrics());
                this.negativeClassWeight(instance.negativeClassWeight());
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder modelName(String modelName) {
            this.modelName = Objects.requireNonNull(modelName, "modelName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        public final Builder randomSeed(@javax.annotation.Nullable Long randomSeed) {
            this.randomSeed = randomSeed;
            return this;
        }

        public final Builder randomSeed(Optional<Long> randomSeed) {
            this.randomSeed = randomSeed.orElse(null);
            return this;
        }

        public final Builder graphName(String graphName) {
            this.graphName = Objects.requireNonNull(graphName, "graphName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder negativeClassWeight(double negativeClassWeight) {
            this.negativeClassWeight = negativeClassWeight;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder pipeline(String pipeline) {
            this.pipeline = Objects.requireNonNull(pipeline, "pipeline");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addMetric(LinkMetric element) {
            if (this.metrics == null) {
                this.metrics = new ArrayList<LinkMetric>();
            }
            this.metrics.add(Objects.requireNonNull(element, "metrics element"));
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder addMetrics(LinkMetric ... elements) {
            if (this.metrics == null) {
                this.metrics = new ArrayList<LinkMetric>();
            }
            for (LinkMetric element : elements) {
                this.metrics.add(Objects.requireNonNull(element, "metrics element"));
            }
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder metrics(Iterable<? extends LinkMetric> elements) {
            this.metrics = new ArrayList<LinkMetric>();
            return this.addAllMetrics(elements);
        }

        public final Builder addAllMetrics(Iterable<? extends LinkMetric> elements) {
            Objects.requireNonNull(elements, "metrics element");
            if (this.metrics == null) {
                this.metrics = new ArrayList<LinkMetric>();
            }
            for (LinkMetric linkMetric : elements) {
                this.metrics.add(Objects.requireNonNull(linkMetric, "metrics element"));
            }
            this.optBits |= 0x80L;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.modelName = null;
            this.username = null;
            this.randomSeed = null;
            this.graphName = null;
            this.negativeClassWeight = 0.0;
            this.pipeline = null;
            if (this.metrics != null) {
                this.metrics.clear();
            }
            return this;
        }

        public LinkPredictionTrainConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableLinkPredictionTrainConfig.validate(new ImmutableLinkPredictionTrainConfig(this));
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean negativeClassWeightIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean metricsIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("modelName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("graphName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("pipeline");
            }
            return "Cannot build LinkPredictionTrainConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="LinkPredictionTrainConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte usernameBuildStage = 0;
        private String username;
        private byte negativeClassWeightBuildStage = 0;
        private double negativeClassWeight;
        private byte metricsBuildStage = 0;
        private List<LinkMetric> metrics;

        private InitShim() {
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutableLinkPredictionTrainConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableLinkPredictionTrainConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableLinkPredictionTrainConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableLinkPredictionTrainConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableLinkPredictionTrainConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableLinkPredictionTrainConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableLinkPredictionTrainConfig.createUnmodifiableList(false, ImmutableLinkPredictionTrainConfig.createSafeList(ImmutableLinkPredictionTrainConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableLinkPredictionTrainConfig.createUnmodifiableList(false, ImmutableLinkPredictionTrainConfig.createSafeList(ImmutableLinkPredictionTrainConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        String username() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(ImmutableLinkPredictionTrainConfig.this.usernameInitialize(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        void username(String username) {
            this.username = username;
            this.usernameBuildStage = 1;
        }

        double negativeClassWeight() {
            if (this.negativeClassWeightBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.negativeClassWeightBuildStage == 0) {
                this.negativeClassWeightBuildStage = (byte)-1;
                this.negativeClassWeight = ImmutableLinkPredictionTrainConfig.this.negativeClassWeightInitialize();
                this.negativeClassWeightBuildStage = 1;
            }
            return this.negativeClassWeight;
        }

        void negativeClassWeight(double negativeClassWeight) {
            this.negativeClassWeight = negativeClassWeight;
            this.negativeClassWeightBuildStage = 1;
        }

        List<LinkMetric> metrics() {
            if (this.metricsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.metricsBuildStage == 0) {
                this.metricsBuildStage = (byte)-1;
                this.metrics = ImmutableLinkPredictionTrainConfig.createUnmodifiableList(false, ImmutableLinkPredictionTrainConfig.createSafeList(ImmutableLinkPredictionTrainConfig.this.metricsInitialize(), true, false));
                this.metricsBuildStage = 1;
            }
            return this.metrics;
        }

        void metrics(List<LinkMetric> metrics) {
            this.metrics = metrics;
            this.metricsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.negativeClassWeightBuildStage == -1) {
                attributes.add("negativeClassWeight");
            }
            if (this.metricsBuildStage == -1) {
                attributes.add("metrics");
            }
            return "Cannot build LinkPredictionTrainConfig, attribute initializers form cycle " + attributes;
        }
    }
}

