/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionPipelineCompanion;
import org.neo4j.gds.ml.linkmodels.pipeline.PipelineInfoResult;
import org.neo4j.gds.ml.linkmodels.pipeline.logisticRegression.LinkLogisticRegressionTrainConfigImpl;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkPredictionPipeline;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class LinkPredictionPipelineConfigureParamsProc
extends BaseProc {
    @Context
    public ModelCatalog modelCatalog;

    @Procedure(name="gds.alpha.ml.pipeline.linkPrediction.configureParams", mode=Mode.READ)
    @Description(value="Configures the parameters of the link prediction train pipeline.")
    public Stream<PipelineInfoResult> configureParams(@Name(value="pipelineName") String pipelineName, @Name(value="parameterSpace") List<Map<String, Object>> parameterSpace) {
        LinkPredictionPipeline pipeline = LinkPredictionPipelineCompanion.getLPPipeline(this.modelCatalog, pipelineName, this.username());
        List trainConfigs = parameterSpace.stream().map(CypherMapWrapper::create).map(rawConfig -> {
            LinkLogisticRegressionTrainConfigImpl config = new LinkLogisticRegressionTrainConfigImpl(rawConfig);
            this.validateConfig((CypherMapWrapper)rawConfig, config.configKeys());
            return config;
        }).collect(Collectors.toList());
        pipeline.setTrainingParameterSpace(trainConfigs);
        return Stream.of(new PipelineInfoResult(pipelineName, pipeline));
    }
}

